/******************************************************************************/
/*									      */
/*	ctk_adaptive_noise_estimation.hh   	        		      */
/*									      */
/*	Author: Ljubomir Josifovski, Sheffield University              	      	      */
/*									      */
/*     CTK VERSION 1.3.5  Apr 22, 2007                    		      */
/*									      */
/******************************************************************************/

#ifndef CTK_ADAPTIVE_NOISE_ESTIMATION_HH
#define CTK_ADAPTIVE_NOISE_ESTIMATION_HH

#include "ctk_block.hh"

/******************************************************************************/
/* 									       */
/*       CLASS NAME:  	AdaptiveNoiseEstimationBlock	       		      */
/*									      */
/******************************************************************************/

class AdaptiveNoiseEstimationBlock:public Block {

private:
  
  static const string type_name;
  static const string help_text;
  
  ParamBool *HAS_DELTAS_param; // True if the input is to be interpretted as having delta static and delta features
  ParamInt *NFRAMES_param;
  ParamFloat *NOISE_THRESHOLD_param;
  ParamFloat *PROBABILITY_THRESHOLD_param;
  ParamFloat *MEMORY_FACTOR_param;

  // copies of parameter values stored locally so that parameters only have to be read once
  int nframes;
  Float noise_threshold;
  Float probability_threshold;
  Float memory_factor;
  bool has_deltas;     

  
  vector<CTKVector *> frame_buffer;
  int frames_left;

  CTKVector *adapted_mask_in;
  
  CTKVector noise_mean;
  CTKVector noise_mean2;
  CTKVector noise_variance;
  CTKVector adapted_mask;
  
#ifdef _RECORD_PUSHED_PULLED
  int frames_pushed;
  int frames_pulled;
#endif

public:
  
  AdaptiveNoiseEstimationBlock(const string &a_name);
  virtual ~AdaptiveNoiseEstimationBlock(){};
  
  virtual Block* clone(const string &new_name) const;

  virtual const string &get_helptext() const {return help_text;}
  
private:
  virtual void reset();
  virtual void compute();
  virtual void close();
  void buffer_one_frame();
  void compute_initial_estimate();
  void update_internal_state(CTKVector *);
  void produce_output();
  inline float erfs(float x);
  
};

#endif


/* End of ctk_adaptive_noise_estimation.hh */
