/******************************************************************************/
/*									      */
/*	ctk_binary_ops.hh	    				    	      */
/*									      */
/*	Class declarations for ctk_binary_ops.cpp		      	      */
/*									      */
/*	Author: Jon Barker, Sheffield University			      */
/*									      */
/*      CTK VERSION 1.3.5  Apr 22, 2007			              */
/*									      */
/******************************************************************************/

#ifndef CTK_BINARY_OPS_HH
#define CTK_BINARY_OPS_HH

#include "ctk_block.hh"

/******************************************************************************/
/*                                                                            */
/*       CLASS NAME: BinaryOpBlock                                            */
/*                                                                            */
/******************************************************************************/

class BinaryOpBlock:public Block {

public:

  BinaryOpBlock(const string &a_name, const string &a_block_type);
  virtual ~BinaryOpBlock(){};
  virtual Block* clone(const string &new_name) const=0;

protected:
  virtual void reset();

private:
  virtual void compute()=0;
  
};

/******************************************************************************/
/*                                                                            */
/*       CLASS NAME: P0_BinaryOpBlock                                          */
/*                                                                            */
/******************************************************************************/

class P0_BinaryOpBlock:public BinaryOpBlock {

public:

  P0_BinaryOpBlock(const string &a_name, const string &a_block_type);
  virtual ~P0_BinaryOpBlock(){};
  virtual Block* clone(const string &new_name) const=0;

protected:
  virtual void reset();

private:
  virtual void compute()=0;
  
};

/******************************************************************************/
/*                                                                            */
/*       CLASS NAME: P1_BinaryOpBlock                                          */
/*                                                                            */
/******************************************************************************/

class P1_BinaryOpBlock:public BinaryOpBlock {

protected:

  class ParamFloat *X_param;

  // Precomputed to save time
  Float param_1;
  
public:

  P1_BinaryOpBlock(const string &a_name, const string &a_block_type);
  virtual ~P1_BinaryOpBlock(){};
  virtual Block* clone(const string &new_name) const=0;

protected:
  virtual void reset();
  
private:
  virtual void compute()=0;
  
};


/******************************************************************************/
/*                                                                            */
/*       CLASS NAME: DividerBlock                                             */
/*                                                                            */
/******************************************************************************/


class DividerBlock:public P0_BinaryOpBlock {

  static const string help_text;
  static const string type_name;

public:

  DividerBlock(string a_name);
  virtual ~DividerBlock(){};

  virtual Block* clone(const string &new_name) const;

  virtual const string &get_helptext() const {return help_text;}

private:

  void compute();

};


/******************************************************************************/
/*                                                                            */
/*       CLASS NAME: ComparatorBlock                                          */
/*                                                                            */
/******************************************************************************/

class ComparatorBlock:public P1_BinaryOpBlock {

  static const string help_text;
  static const string type_name;

public:

  ComparatorBlock(string a_name);
  virtual ~ComparatorBlock(){};

  virtual Block* clone(const string &new_name) const;

  virtual const string &get_helptext() const {return help_text;}

private:

  void compute();
  
};


#endif

/* End of ctk_binary_ops.hh */
