/******************************************************************************/
/*									      */
/*	ctk_decimator.hh   			             		      */
/*									      */
/*	Class declarations for ctk_decimator.cpp	              	      */
/*									      */
/*	Author: Jon Barker, Sheffield University			      */
/*									      */
/*      CTK VERSION 1.3.5  Apr 22, 2007			      */
/*									      */
/******************************************************************************/

#ifndef CTK_DECIMATOR_HH
#define CTK_DECIMATOR_HH

#include "ctk_block.hh"


/******************************************************************************/
/*                                                                            */
/*       CLASS NAME: DecimatorBlock                                           */
/*                                                                            */
/******************************************************************************/

const Integer	PARAM_DEFAULT_DECIMATION_MULTIPLE	= 1;


class DecimatorBlock:public Block {

private:
  static const string help_text;
  static const string type_name;

  class ParamInt *MULTIPLE_param;
  class ParamFloat *OUTPUT_RATE_param;

  Integer start_count;
  Integer count;
  
public:

  DecimatorBlock(const string &a_name);
  virtual ~DecimatorBlock(){};

  virtual Block* clone(const string &new_name) const;

  virtual const string &get_helptext() const {return help_text;}

private:

  virtual void reset();
  
  virtual void compute();

  virtual void close();
};


/******************************************************************************/
/*                                                                            */
/*       CLASS NAME: UpsampleBlock                                            */
/*                                                                            */
/******************************************************************************/

class UpsampleBlock:public Block {

  static const string type_name;
  static const string help_text;

private:
  
  class ParamInt *MULTIPLE_param;
  class ParamFloat *OUTPUT_RATE_param;

  Integer multiple;
  
public:

  UpsampleBlock(const string &a_name);
  virtual ~UpsampleBlock(){};

  virtual Block* clone(const string &new_name) const;

  virtual const string &get_helptext() const {return help_text;}

private:

  virtual void reset();
  
  virtual void compute();

  virtual void close();
};

#endif


/* End of ctk_decimator.hh */
