/******************************************************************************/
/*									      */
/*	ctk_filter_colour.hh   			             		      */
/*									      */
/*	Author: Martin Cooke, Sheffield University              	      	      */
/*									      */
/*     CTK VERSION 1.3.5  Apr 22, 2007                    		      */
/*									      */
/******************************************************************************/

 
#ifndef CTK_FILTER_COLOUR_HH
#define CTK_FILTER_COLOUR_HH

#include <deque>
#include <map>

#include "ctk_block.hh"


/******************************************************************************/
/*									      */
/*	CLASS NAME: FilterColourBlock		              	       	      */
/*									      */
/******************************************************************************/

// Takes a colouring and applies various 'filtering' operations to it, including
// removal of groups which are shorter than a threshold or have fewer members than
// a threshold.

// The algorithm uses a fixed buffer of a given number of frames.


const Integer	PARAM_DEFAULT_MIN_FRAMES	= 2; // must exist for at least this to survive
const Boolean   PARAM_DEFAULT_MIN_MEMBERS    = 0; // must have at least these many members

struct Colour {
  int count;  // number of elements
  int first;  // first frame this appeared
  int latest; // latest frame this appeared
};

typedef map<int,Colour> Colourmap;

class FilterColourBlock:public Block {

  static const string type_name;
  static const string help_text;

private:

  class ParamInt *MIN_FRAMES_param;
  class ParamInt *MIN_MEMBERS_param;

  int window_size;
  int frame_number;
  int vector_width;
  int min_frames;
  int min_members;
  
  CTKVector xvlast;  
  deque<CTKVector *> frame_buffer;
  Colourmap m;

public:

  
  FilterColourBlock(const string &a_name);
  virtual ~FilterColourBlock();

  virtual Block* clone(const string &new_name) const;
  
  virtual const string &get_helptext() const {return help_text;}

private:

  virtual void reset();

  virtual void compute();

  virtual void flush_buffer();

  
};

#endif


/* End of ctk_filter_colour.hh */
