/******************************************************************************/
/*									      */
/*	ctk_gmask.hh   			             		      */
/*									      */
/*	Author: Ljubomir Josifovski, Sheffield University              	      */
/*									      */
/*     CTK VERSION 1.3.5  Apr 22, 2007                    		      */
/*									      */
/******************************************************************************/

 
#ifndef CTK_GMASK_HH
#define CTK_GMASK_HH

#include "ctk_block.hh"

/******************************************************************************/
/* 									       */
/*       CLASS NAME: GMaskBlock 					      */
/*									      */
/******************************************************************************/

class GMaskBlock:public Block {

private:

   static const string type_name;
   static const string help_text;

   ParamFloat *NOISE_THRESHOLD_param;
   ParamFloat *PROBABILITY_THRESHOLD_param;

   Float noise_threshold;
   Float probability_threshold;
#ifdef _RECORD_PUSHED_PULLED
   int frames_pushed;
   int frames_pulled;
#endif

public:

   GMaskBlock(const string &a_name);
   virtual ~GMaskBlock(){};

   virtual Block* clone(const string &new_name) const;

   virtual const string &get_helptext() const {return help_text;}

private:
   virtual void reset();
   virtual void compute();
   virtual void close();
   inline float gmask_erfs(float x);

};


#endif


/* End of ctk_gmask.hh */
