/******************************************************************************/
/*									      */
/*	ctk_integrator.hh   			      			      */
/*									      */
/*	Class declarations for ctk_integrator.cpp	               	      */
/*									      */
/*	Author: Jon Barker, Sheffield University			      */
/*									      */
/*      CTK VERSION 1.3.5  Apr 22, 2007		        	      */
/*									      */
/******************************************************************************/

#ifndef CTK_INTEGRATOR_HH
#define CTK_INTEGRATOR_HH

#include "ctk_block.hh"


const Float	PARAM_DEFAULT_TIME_CONSTANT	= 8.0;

/******************************************************************************/
/*                                                                            */
/*       CLASS NAME: IntegratorBlock                                          */
/*                                                                            */
/******************************************************************************/

class IntegratorBlock:public Block {

private:

  static const string type_name;
  static const string help_text;

  ParamFloat *TIME_CONST_param;
  
  Float sumS;  
  CTKVector sumF;
  Integer frame_width;
  
  //
  //
  //
  
public:

  IntegratorBlock(const string &a_name);
  virtual ~IntegratorBlock(){};

  virtual Block* clone(const string &new_name) const;

  virtual const string &get_helptext() const {return help_text;}

protected:
 
  virtual void reset();
  virtual void compute();

};


/******************************************************************************/
/*                                                                            */
/*       CLASS NAME: LeakyIntegratorBlock                                     */
/*                                                                            */
/******************************************************************************/

class LeakyIntegratorBlock:public Block {

private:

  static const string type_name;
  static const string help_text;

  ParamFloat *TIME_CONST_param;
  
  Float sumS;  
  CTKVector sumF;
  
  Integer frame_width;
  Float decay;
  Float intgain;
  
  //
  //
  //
  
  
public:

  LeakyIntegratorBlock(const string &a_name);
  virtual ~LeakyIntegratorBlock(){};

  virtual Block* clone(const string &new_name) const;

  virtual const string &get_helptext() const {return help_text;}

private:
 
  virtual void reset();

  virtual void compute();

};


#endif


/* End of ctk_integrator.hh */
