/******************************************************************************/
/*									      */
/*	ctk_localisation.hh   		      	        		      */
/*									      */
/*	Class declarations for ctk_localisation.cpp	               	      */
/*									      */
/*	Author: Jon Barker, Sheffield University			      */
/*									      */
/*      CTK VERSION 1.3.5  Apr 22, 2007			      */
/*									      */
/******************************************************************************/

#ifndef CTK_LOCALISATION_HH
#define CTK_LOCALISATION_HH

#include "ctk_block.hh"

/******************************************************************************/
/*                                                                            */
/*       CLASS NAME: LocalisationBlock                                        */
/*                                                                            */
/******************************************************************************/

class LocalisationBlock:public Block {

public:

  LocalisationBlock(const string &a_name, const string &a_block_type);
  virtual ~LocalisationBlock(){};

  virtual Block* clone(const string &new_name) const=0;

protected:
  virtual void reset();

private:
  virtual void compute()=0;
};


/******************************************************************************/
/*                                                                            */
/*       CLASS NAME: LindemannLocalisationBlock                               */
/*                                                                            */
/******************************************************************************/

const int DEFAULT_M_PARAM=40;

class LindemannLocalisationBlock:public LocalisationBlock {

  static const string type_name;
  static const string help_text;

private:
  class ParamInt *M_param;

  Float *r, *l, *k, *w1, *w2, *phi, *ir, *il, *psi;
  Float k1, k2;

  Integer channels;  // Number of channels per input stream
  Integer M;
  Integer N;
  
public:

  LindemannLocalisationBlock(const string &a_name);
  virtual ~LindemannLocalisationBlock();

  virtual Block* clone(const string &new_name) const;

  virtual const string &get_helptext() const {return help_text;}

private:

  virtual void reset();
  virtual void compute();
};


#endif

/* End of ctk_localisation.hh */
