/******************************************************************************/
/*									      */
/*	ctk_qfigure.hh  			             		      */
/*									      */
/*	Matlab style Figure using Qt for matrix display	              	      */
/*									      */
/*	Author: Ljubomir Josifovski MAR/2001			      */
/*									      */
/*      CTK VERSION 1.3.5  Apr 22, 2007			     	      */
/*									      */
/******************************************************************************/

#ifndef CTK_QFIGURE_HH
#define CTK_QFIGURE_HH

#ifdef _HAS_QT

#include <qapplication.h>

#include <qwidget.h>
#include <qpainter.h>
#include <qimage.h>
#include <qmenubar.h>
#include <qapp.h>
#include <qcolor.h>

#endif

#include <string.h>
#include <iostream>
#include <assert.h>

#include "ctk_block.hh"

/******************************************************************************/
/*                                                                            */
/*       CLASS NAME: QPlot                                                    */
/*                                                                            */
/******************************************************************************/

class QWidget;

#ifdef _HAS_QT

class QPlot : public QWidget
{

public:
   QPlot(vector<Float> data, int width =400, int height =300, const char* caption ="QFigure");
  ~QPlot(){};
  
  void paintEvent( QPaintEvent * );
 

private:

  vector<Float> data;
  int nx;
   
};

#endif  // _HAS_QT

/******************************************************************************/
/*                                                                            */
/*       CLASS NAME: QFigure                                    */
/*                                                                            */
/******************************************************************************/

#ifdef _HAS_QT

class QFigure : public QWidget, public QImage
{

public:
   QFigure(vector<CTKVector*> data, int width =400, int height =300, char*caption ="QFigure");

protected:
   void  paintEvent( QPaintEvent * );

private:
   // Matlab's jet colormap
   static const int numColors;
   static const int colormap[][3];
};

#endif // #ifdef _HAS_QT


/********************************************************************************/
/*										*/
/*     CLASS NAME: QFigureBlock                                        		*/
/*										*/
/********************************************************************************/

class QFigureBlock:public Block {

private:

  static const string type_name;
  static const string help_text;

  static vector<QWidget*> widget_list;
  
public:

  QFigureBlock(const string &a_name);
  virtual ~QFigureBlock();
  
  virtual const string &get_helptext() const {return help_text;}
  
  virtual Block* clone(const string &new_name) const;

private:

  virtual void reset();
  virtual void compute();
  
  virtual void close();
  virtual void close_final();

  void free_storage();

  //
  // 
  static int global_figure_number;

  int figure_number;
  
  Boolean output_connected;
  vector<Float> sample_buffer;
  vector<CTKVector*> vector_buffer;
  
  ParamString *title_param;
  ParamInt *width_param;
  ParamInt *height_param;
  ParamBool *active_param;
  
  string title;
  int width;
  int height;
  Boolean active;
  

};


#endif  // #ifndef CTK_QFIGURE_HH

/* End of ctk_qfigure.hh */
