/******************************************************************************/
/*									      */
/*	ctk_reducer.hh   			      			      */
/*									      */
/*	Class declarations for ctk_reducer.cpp		         	      */
/*									      */
/*	Author: Jon Barker, Sheffield University			      */
/*									      */
/*      CTK VERSION 1.3.5  Apr 22, 2007			      */
/*									      */
/******************************************************************************/

#ifndef CTK_REDUCER_HH
#define CTK_REDUCER_HH

#include "ctk_block.hh"
#include "ctk_array_iterator.hh"

class ParamString;

/******************************************************************************/
/*                                                                            */
/*       CLASS NAME: ReducerBlockAbstract                                         */
/*                                                                            */
/******************************************************************************/


class ReducerBlockAbstract:public Block {

private:

  ParamString *AXIS_param;
  Integer op_dim;  // Dimension index for averaging over

protected:

  Integer n_dims;   // Number of input dimensions
  Integer out_storage;  // Storage required for output data
  vector<Integer> dim_sizes;
  vector<Integer> strides;

  // Storage for optimized 2-D case precompute
  Integer dims_x, dims_y, stride_y, stride_x;

  //
  //
  //

public:

  ReducerBlockAbstract(const string &a_name, const string &a_type);
  virtual ~ReducerBlockAbstract(){};

  virtual Block* clone(const string &new_name) const = 0;

protected:
  
  virtual void reset();
  
private:

  virtual void compute()=0;
  
  virtual void build_output_data_descriptors();


};

/******************************************************************************/
/*                                                                            */
/*       CLASS NAME: AveragerBlock                                             */
/*                                                                            */
/******************************************************************************/

class AveragerBlock:public ReducerBlockAbstract {

  static const string type_name;
  static const string help_text;

  //
  //
  //
  
public:

  AveragerBlock(const string &a_name);
  virtual ~AveragerBlock(){};
  
  virtual Block* clone(const string &new_name) const;

  virtual const string &get_helptext() const {return help_text;}

private:

  void compute();

};


/******************************************************************************/
/*                                                                            */
/*       CLASS NAME: SumBlock                                             */
/*                                                                            */
/******************************************************************************/

class SumBlock:public ReducerBlockAbstract {

  static const string type_name;
  static const string help_text;

  //
  //
  //
  
public:

  SumBlock(const string &a_name);
  virtual ~SumBlock(){};
  
  virtual Block* clone(const string &new_name) const;

  virtual const string &get_helptext() const {return help_text;}

private:

  void compute();

};

/******************************************************************************/
/*                                                                            */
/*       CLASS NAME: ReducerBlock                                             */
/*                                                                            */
/******************************************************************************/

class ReducerBlock:public ReducerBlockAbstract {

  static const string type_name;
  static const string help_text;

public:

  ReducerBlock(const string &a_name);
  virtual ~ReducerBlock(){};

  virtual Block* clone(const string &new_name) const;

  virtual const string &get_helptext() const {return help_text;}

protected:
  
  virtual void reset();
  
private:

  void compute();

};


/******************************************************************************/
/*                                                                            */
/*       CLASS NAME: FindBlockAbstract                                        */
/*                                                                            */
/******************************************************************************/

class FindBlockAbstract:public ReducerBlockAbstract {

public:
  
  FindBlockAbstract(const string &a_name, const string &a_type_name);
  virtual ~FindBlockAbstract(){};

  virtual Block* clone(const string &new_name) const = 0;

protected:
  
  virtual void compute();

  virtual array_iterator<Float> find_thing(array_iterator<Float> pbegin, array_iterator<Float> pend, Integer &pos, bool &is_thing)=0;
};

/******************************************************************************/
/*                                                                            */
/*       CLASS NAME: PeakBlock                                                */
/*                                                                            */
/******************************************************************************/

class PeakBlock:public FindBlockAbstract {

  static const string type_name;
  static const string help_text;

public:

  PeakBlock(const string &a_name);
  virtual ~PeakBlock(){};

  virtual Block* clone(const string &new_name) const;

  virtual const string &get_helptext() const {return help_text;}

protected:

  virtual array_iterator<Float> find_thing(array_iterator<Float> pbegin, array_iterator<Float> pend, Integer &pos, bool &is_thing);

};

/******************************************************************************/
/*                                                                            */
/*       CLASS NAME: FindMinBlock                                                */
/*                                                                            */
/******************************************************************************/

class FindMinBlock:public FindBlockAbstract {

  static const string type_name;
  static const string help_text;

public:

  FindMinBlock(const string &a_name);
  virtual ~FindMinBlock(){};

  virtual Block* clone(const string &new_name) const;

  virtual const string &get_helptext() const {return help_text;}

protected:

  virtual array_iterator<Float> find_thing(array_iterator<Float> pbegin, array_iterator<Float> pend, Integer &pos, bool &is_thing);

};


/******************************************************************************/
/*                                                                            */
/*       CLASS NAME: FindMaxBlock                                                */
/*                                                                            */
/******************************************************************************/

class FindMaxBlock:public FindBlockAbstract {

  static const string type_name;
  static const string help_text;

public:

  FindMaxBlock(const string &a_name);
  virtual ~FindMaxBlock(){};

  virtual Block* clone(const string &new_name) const;

  virtual const string &get_helptext() const {return help_text;}

protected:

  virtual array_iterator<Float> find_thing(array_iterator<Float> pbegin, array_iterator<Float> pend, Integer &pos, bool &is_thing);

};


#endif


/* End of ctk_reducer.hh */
