/******************************************************************************/
/*									      */
/*	ctk_FFT.hh   			        			      */
/*									      */
/*	Class declarations for ctk_FFT.cpp		         	      */
/*									      */
/*	Author: Jon Barker, Sheffield University			      */
/*									      */
/*      CTK VERSION 1.3.5  Apr 22, 2007			      */
/*									      */
/******************************************************************************/

#ifndef CTK_FFT_HH
#define CTK_FFT_HH

#include "ctk_block.hh"

class FFTBlock:public Block {

  static const string type_name;
  static const string help_text;

private:

  CTKVector real;
  CTKVector imag;

  UInteger outframe_size;
  Boolean must_pad;
  
public:

  FFTBlock(const string &a_name);
  virtual ~FFTBlock(){};
  
  virtual Block* clone(const string &new_name) const;

  virtual const string &get_helptext() const {return help_text;}

  
private:

  virtual void reset();

  virtual void build_output_data_descriptors();

  virtual void compute();


};


#endif


/* End of ctk_FFT.hh */
