/******************************************************************************/
/*									      */
/*	ctk_HMM_MS_decoder.hh   			              	      */
/*									      */
/*	Class declarations for ctk_HMM_MS_decoder.cpp	              	      */
/*									      */
/*	Author: Jon Barker, Sheffield University			      */
/*									      */
/*      CTK VERSION 1.3.5  Apr 22, 2007			     	      */
/*									      */
/******************************************************************************/

#ifndef CTK_HMM_MS_DECODER_HH
#define CTK_HMM_MS_DECODER_HH

#include "ctk_decoder.hh"
#include "ctk_HMM_decoder.hh"


/******************************************************************************/
/*									      */
/*	CLASS NAME: BaseMS_HMMDecoderBlock	               	              */
/*									      */
/******************************************************************************/
// Multisource Decoder  


class BaseMS_HMMDecoderBlock: public BaseMD_HMMDecoderBlock {


private:

  ParamFloat *MD_WEIGHT_param;
  ParamEnumerated *NORMALISE_MODE_param;
  ParamString *GROUP_FILE_NAME_param;
  ParamFloat *SPEECH_GROUP_BIAS_param;
  ParamInt *TEMPORAL_WINDOW_SIZE_param;
  ParamEnumerated *PROB_CALC_param;
  
  Float md_weight;
  map<Integer, Integer> group_label_to_number_map; // Maps a group_mask label onto a group_no
  map<Integer, Integer> group_number_to_label_map; // Maps a group_no onto a group mask label
  
  map<int, Group> group_summary_map; // Maps a group_mask label onto a group description

  vector<Boolean> groups_active;  // indicates which groups are currently active

  // List of group merging counters. Holds group number and associated counter. Counter
  // decremented for each process() and group is merged when counter reaches 0.
  list<pair<int, int> > group_merge_counters; 
  
  Integer next_group_number;

  Integer frame_no;

  bool use_soft_multisource;

  vector<Group> groups;

  float mean_likelihood_scale_factor;
  float group_hypothesis_merging_parameter;
  float speech_group_bias;
  //
  //
  //
  
public:

  BaseMS_HMMDecoderBlock(const string &a_name, const string &a_type);
  virtual ~BaseMS_HMMDecoderBlock(){};

  virtual Block* clone(const string &new_name) const =0;

protected:
  void set_use_soft_multisource() {use_soft_multisource=true;}
  
  const ParamEnumerated *get_PROB_CALC_param() const {return PROB_CALC_param;}

private:
  
  virtual void reset();
  virtual void compute();
  virtual void close();

  virtual void build_output_data_descriptors();
  
  virtual void write_hypothesis(RecoHypothesis *hyp, FILE *file);

  void start_end_detection(const vector<Float> &group, vector<Integer> &groups_starting, vector<Integer> &groups_ending, map<Integer, Integer> &a_group_label_to_number_map, map<Integer, Integer> &a_group_number_to_label_map);

  void read_group_summary_file(const string &filename, map<int, Group> &group_summary_map); 
  void update_group_map(const vector<Float> &input_groups);
  void map_group_labels(const vector<Float> &input_groups, vector<int> &mapped_groups);
  
  void update_group_stats(const vector<Integer> &mapped_group, const CTKVector &mask, vector<Group> &groups);

  // Remove 0, -ve and duplicate group labels 
  void tidy_label_list(vector<Float> *labels);

  // Call to decoder to merge hypotheses that are complementary wrt group group_number
  void merge_group(int group_number, float merging_parameter);
};

/******************************************************************************/
/*									      */
/*	CLASS NAME: MS_HMMDecoderBlock	              	       	              */
/*									      */
/******************************************************************************/
// Multisource Decoder  

class MS_HMMDecoderBlock: public BaseMS_HMMDecoderBlock {

  static const string type_name;
  static const string help_text;

  //
  //
  //
  
public:

  MS_HMMDecoderBlock(const string &a_name);
  virtual ~MS_HMMDecoderBlock(){};

  virtual Block* clone(const string &new_name) const;
  
  virtual const string &get_helptext() const {return help_text;}

private:
  
  HMMMixture *get_HMM_mixture_prototype() const;


};



/******************************************************************************/
/*									      */
/*	CLASS NAME: MSSoft_HMMDecoderBlock	              	       	              */
/*									      */
/******************************************************************************/
// Multisource Decoder 

class MSSoft_HMMDecoderBlock: public BaseMS_HMMDecoderBlock {

  static const string type_name;
  static const string help_text;

  //
  //
  //
  
public:

  MSSoft_HMMDecoderBlock(const string &a_name);
  virtual ~MSSoft_HMMDecoderBlock(){};

  virtual Block* clone(const string &new_name) const;
  
  virtual const string &get_helptext() const {return help_text;}

private:
  
  HMMMixture *get_HMM_mixture_prototype() const; 

};


#endif


/* End of ctk_HMM_decoder.hh */
