/******************************************************************************/
/*                                                                            */
/*      ctk_HMM_edit.hh                                                            */
/*                                                                            */
/*      Class declarations for ctk_HMM.cpp                                    */
/*                                                                            */
/*      Author: Jon Barker, Sheffield University                              */
/*                                                                            */
/*      CTK VERSION 1.3.5  Apr 22, 2007                              */
/*                                                                            */
/******************************************************************************/

#ifndef CTK_HMM_EDIT_HH
#define CTK_HMM_EDIT_HH

#include "ctk_local.hh"
#include "ctk_HMM.hh"

// HMMEdit 
// Classes for constructing new HMMs by transforming an existing HMMs


// Normalise a vector of logprob so that the probabilities sum to 1.0
template <class T>
T log_normalise(vector<T> &x) {
  T sumweight=0.0;
  for(typename vector<T>::iterator it=x.begin(), it_end=x.end(); it!=it_end; ++it)
    sumweight+=exp(*it);
  T logsumweight=log(sumweight);
  for(typename vector<T>::iterator it=x.begin(), it_end=x.end(); it!=it_end; ++it)
    *it-=logsumweight;
  return logsumweight;
}


/******************************************************************************/
/*									      */
/*	CLASS NAME: HMMEdit      	                    	       	      */
/*									      */
/******************************************************************************/

class HMMEdit {
private:
  
public:
  HMMEdit(){};

  virtual HMM *edit(const HMM &hmm) const =0;

};

/******************************************************************************/
/*									      */
/*	CLASS NAME: HMMEditNullEdit	                    	       	      */
/*									      */
/******************************************************************************/

class HMMEditNullEdit : public HMMEdit {
private:
  
public:
  HMMEditNullEdit();

  virtual HMM *edit(const HMM &hmm) const;
};


/******************************************************************************/
/*									      */
/*	CLASS NAME: HMMEditPruneTransitions	           	       	      */
/*									      */
/******************************************************************************/

class HMMEditPruneTransitions: public HMMEdit {
private:
  float threshold_;
  
public:
  HMMEditPruneTransitions(float threshold);

  virtual HMM *edit(const HMM &hmm) const;
};

/******************************************************************************/
/*									      */
/*	CLASS NAME: HMMEditMaxDuration   	           	       	      */
/*									      */
/******************************************************************************/
// Impose Max Duration through HMM topology

class HMMEditMaxDuration: public HMMEdit {
private:

public:
  
  HMMEditMaxDuration();

  virtual HMM *edit(const HMM &hmm) const;
};

/******************************************************************************/
/*									      */
/*	CLASS NAME: HMMEditWarpTransitions   	           	       	      */
/*									      */
/******************************************************************************/

class HMMEditWarpTransitions: public HMMEdit {

private:

  float threshold_;
  
public:
  
  HMMEditWarpTransitions(float threshold);

  virtual HMM *edit(const HMM &hmm) const;
};


/******************************************************************************/
/*									      */
/*	CLASS NAME: HMMEditMixtureSeparation	           	       	      */
/*									      */
/******************************************************************************/

class HMMEditMixtureSeparation: public HMMEdit {
private:

  int nmixes_;  // number of mixtures per state
  
public:
  
  HMMEditMixtureSeparation(int nmixes);

  virtual HMM *edit(const HMM &hmm) const;
};


/******************************************************************************/
// Non-class methods

Transitions construct_temporal_continuity_trans(const Transitions &old_trans, const vector<int> &new_states_per_old_state, const vector<HMMFloat> &weights);

Transitions construct_max_duration_trans(const Transitions &old_trans, const vector<int> &new_states_per_old_state);

vector<int> get_nearest_neighbours(HMMState *state, int mix_index, int K);


#endif

/* End of ctk_HMM_edit.hh */
