/******************************************************************************/
/*									      */
/*	ctk_acg_pitch.hh   			      			      */
/*									      */
/*	Author: Martin Cooke, Sheffield University			      */
/*									      */
/*      CTK VERSION 1.3.5  Apr 22, 2007 			      */
/*									      */
/******************************************************************************/

#ifndef CTK_ACGPITCH_HH
#define CTK_ACGPITCH_HH

#include "ctk_block.hh"

/******************************************************************************/
/*                                                                            */
/*       CLASS NAME: AcgPitchBlock                                          */
/*                                                                            */
/******************************************************************************/

const int	PARAM_DEFAULT_NPITCHES	= 3;

class AcgPitchBlock:public Block {

private:

  static const string type_name;
  static const string help_text;
  
  class ParamInt *NPITCHES_param;
  
  Integer n_dims;   // Number of input dimensions
  int n_lags;
  int n_chans;
  vector<Integer> dim_sizes;
  CTKVector cfs;
  int maxpitches;
  float fs;

  
public:

  AcgPitchBlock(const string &a_name);
  virtual ~AcgPitchBlock(){};

  virtual Block* clone(const string &new_name) const;

  virtual const string &get_helptext() const {return help_text;}

private:
 
  virtual void reset();

  virtual void build_output_data_descriptors();
  
  virtual void compute();


};


#endif


/* End of ctk_acg_pitch.hh */
