/******************************************************************************/
/*									      */
/*	ctk_auditory.hh   		         			      */
/*									      */
/*	Simple Auditory stuff                                        	      */
/*									      */
/*	Author: Jon Barker, Sheffield University			      */
/*									      */
/*      CTK VERSION 1.3.5  Apr 22, 2007		         	      */
/*									      */
/******************************************************************************/

#ifndef CTK_AUDITORY_HH
#define CTK_AUDITORY_HH

const Float MINDB = -20.0;    /* Minimum DB value */
const Float MINLARG = 0.0;

const Float BW_CORRECTION = 1.019;  /* ERB bandwidth correction 4th order  */

inline Float erb(Float f){return 24.7*(4.37e-3*f+1.0);};
inline Float hzToERBrate(Float f) {return 21.4*log10(4.37e-3*f+1.0);}
inline Float ERBrateToHz(Float f) {return (pow(10.0,(f/21.4))-1.0)/4.37e-3;}

inline Float hzToMel(Float f) {return 1125.0*log(0.0016*f+1.0);}
inline Float melToHz(Float m) {return 625.0*(exp(m/1125.0)-1.0);}

inline Float hzToHz(Float f) {return f;} // Convenience function - for linear scales

inline Float DBtoAmplitude(float dB) {
   return pow(10.0,(dB/20.0));
}

inline Float AmplitudetoDB(float amp) {
	if (amp > MINLARG)
		return 20.0*log10(amp);
	else
		return MINDB;
}

#endif

/* End of ctk_auditory.hh */
