/******************************************************************************/
/*									      */
/*	ctk_binaural.hh	      			                              */
/*									      */
/*	Class declarations for ctk_binaural.cpp		         	      */
/*									      */
/*	Author: Sue Harding, Sheffield University			      */
/*									      */
/*      CTK VERSION 1.3.5  Apr 22, 2007		         	      */
/*									      */
/******************************************************************************/

#ifndef CTK_BINAURAL_HH
#define CTK_BINAURAL_HH

#include "ctk_block.hh"
#include "ctk_array_iterator.hh"


/******************************************************************************/
/*                                                                            */
/*       CLASS NAME: SkeletoniseBlock                                         */
/*                                                                            */
/******************************************************************************/
// Produce skeletonised output by finding the peaks along one axis and
// convolving these with a Gaussian with standard deviation that varies across
// another axis

// default axis along which Gaussians vary
const char PARAM_DEFAULT_CHANNEL_AXIS[]	= "FREQUENCY";
// default std dev for lowest frequency channel
const Float PARAM_DEFAULT_LOW_CHAN_STDDEV	= 4;
// default std dev for highest frequency channel
const Float PARAM_DEFAULT_HIGH_CHAN_STDDEV	= 1;
// default number of std devs from the mean used as limit for Gaussians 
const Float PARAM_DEFAULT_GAUSS_LIMIT	= 2;

class SkeletoniseBlock:public Block {

  static const string type_name;
  static const string help_text;

private:
  
  class ParamString *CHANNEL_AXIS_param;
  class ParamString *PEAK_AXIS_param;
  class ParamFloat *LOW_CHAN_STDDEV_param;
  class ParamFloat *HIGH_CHAN_STDDEV_param;
  class ParamFloat *GAUSS_LIMIT_param;

  string channel_axis_name;	// name of axis along which gaussians vary
  string peak_axis_name;	// name of axis along which to find peaks
  Float low_chan_stddev;	// std dev for lowest channel
  Float high_chan_stddev;	// std dev for highest channel
  Float gauss_limit;		// no. of std devs from mean used as limit for Gaussians
  
  Integer n_dims;   // Number of input dimensions
  vector<Integer> dim_sizes;
  vector<Integer> strides;

  Integer op_dim;	// dimension on which to operate
  Integer dims_x, dims_y, stride_y, stride_x; // Storage for optimized 2-D case precompute

  Integer out_storage;  // Storage required for output data

  Integer n_chans;		// number of channels
  vector<Float> chan_stddev;	// std dev for Gaussian for each channel

public:

  SkeletoniseBlock(const string &a_name);
  virtual ~SkeletoniseBlock(){};
  
  virtual Block* clone(const string &new_name) const;

  virtual const string &get_helptext() const {return help_text;}

private:

  bool find_all_peaks(array_iterator<Float> ipbegin, array_iterator<Float> ipend, Float *peakheightp, Float *peakexistp);

  void conv_with_gauss(Float *peakheightp, Float *skeletonp, Integer len, Float sigma, Float gauss_limit);

  virtual void reset();
  
  virtual void build_output_data_descriptors();

  virtual void compute();

};


#endif

/* End of ctk_binaural.hh */
