/******************************************************************************/
/*									      */
/*	ctk_command_line.hh	    		      			      */
/*									      */
/*	Class declarations for ctk_command_line.cpp	      		      */
/*									      */
/*	Author: Jon Barker, Sheffield University			      */
/*									      */
/*      CTK VERSION 1.3.5  Apr 22, 2007			      */
/*									      */
/******************************************************************************/

#ifndef CTK_COMMAND_LINE_HH
#define CTK_COMMAND_LINE_HH

#include "ctk_local.hh"

#include <string>
#include <vector>
#include <map>


typedef vector<string> StringVector;

class CTKCommandOption {

private:
  string name;                    // The option's name.  
  vector<StringVector*> option_list; // a list of argument values for each occurrence of this option
  Integer occurrences;             // Number of times this option appears on command line
  Integer nargs;
  Integer current_occurrence;
  //
  //
  //
  
public:
  CTKCommandOption(const string &aname);

  void add_argument(const string &this_argument);
  Integer set_arguments(Integer argc, const char *argv[]);
  string get_argument(Integer narg);
  Boolean is_present();
  
  void reset_to_first_occurrence();
  Boolean next_occurrence();
};




class CTKCommandLine {
  
private:

  UInteger current_argument_list;
  
  map<string, CTKCommandOption*> option_map;
  vector<string> argument;
  vector<vector<string> > argument_list;
  
  //
  //
  //
  
public:

  CTKCommandLine(const string &format, int argc, const char *argv[]);

  UInteger argument_count();
  string get_argument(UInteger n);
  vector<string> get_arguments();
  Boolean next_argument_list();
  void reset_to_first_argument_list();
  
  Boolean option_is_valid(const string &option_name);
  Boolean option_is_present(const string &option_name);
  string get_option_argument(const string &option_name, Integer noption_arg=1);
  void reset_to_first_occurrence(const string &option_name);
  Boolean next_occurrence(const string &option_name);
  
private:
  void add_to_argument_list(const string &filelist);
  Boolean read_format(const string &format_string);
  vector<string*> make_word_list(const string &words);
  Boolean parse(int argc, const char *argv[]);
  Boolean is_option(const string &word);  // Return's true if the string looks like an option identifier
};

//----------------------- Non-class methods 


void setParametersFromCommandline(class Block &block, class CTKCommandLine &command_line, class CTKReader &script);

#endif

/* End of ctk_command_line.hh */
