/******************************************************************************/
/*									      */
/*	ctk_data_descriptor.hh	    					      */
/*									      */
/*	Class declarations for ctk_data_descriptor.cpp			      */
/*									      */
/*	Author: Jon Barker, Sheffield University			      */
/*									      */
/*      CTK VERSION 1.3.5  Apr 22, 2007			      */
/*									      */
/******************************************************************************/

#ifndef CTK_DATA_DESCRIPTOR_HH
#define CTK_DATA_DESCRIPTOR_HH

#include <vector>
#include <string>

#include "ctk_local.hh"
#include "ctk_types.hh"   // For CTKVector and CTKSample

class DimensionDescriptor;


/******************************************************************************/
/*									      */
/*	CLASS NAME: DataDescriptor		      			      */
/*									      */
/******************************************************************************/

class DataDescriptor {
  
private:
  Integer n_dimensions;
  Boolean sample_data_flag;
  vector<Integer> dimension_sizes;
  mutable vector<Integer> strides;   
  
  vector<DimensionDescriptor*> dimension;

  vector<DimensionDescriptor*>::iterator begin(){return dimension.begin();}
  vector<DimensionDescriptor*>::iterator end(){return dimension.end();}

  vector<DimensionDescriptor*>::const_iterator begin() const {return dimension.begin();}
  vector<DimensionDescriptor*>::const_iterator end() const {return dimension.end();}
    
public:

  DataDescriptor();
  DataDescriptor(const DataDescriptor &this_descriptor);
  
  ~DataDescriptor();

  
  void add_inner_dimension(const string &name, const CTKVector &axis);
  void add_outer_dimension(const string &name, const CTKVector &axis);
  Boolean add_dimension_at(Integer n, const string &name, const CTKVector &axis);

  Boolean replace_dimension(const string &input_name, const string &output_name, const CTKVector &axis);   
  Boolean replace_dimension_at(Integer n, const string &name, const CTKVector &axis);

  Boolean remove_inner_dimension();
  Boolean remove_outer_dimension();

  Boolean remove_dimension(const string &axis_name);
  Boolean remove_dimension(Integer n);

  
  Boolean is_sample_data() const;
  Integer get_n_dimensions() const;
  Integer get_storage() const;
  
  const DimensionDescriptor *get_dimension(const string &name) const;
  const DimensionDescriptor *get_dimension(Integer index) const;
  const DimensionDescriptor *get_inner_dimension() const;
  const DimensionDescriptor *get_outer_dimension() const;
  const vector<Integer> &get_dimension_sizes() const;
  const vector<Integer> &get_strides() const;
  
  Boolean matches_shape_of(const DataDescriptor *this_dd) const;
};


/******************************************************************************/
/*									      */
/*	CLASS NAME: DimensionDescriptor		      			      */
/*									      */
/******************************************************************************/

class DimensionDescriptor {

  string name;
  Integer index;  
  CTKVector axis_values;
  Integer nPoints;

  //
  //
  //
  
public:

  DimensionDescriptor(const DimensionDescriptor &this_descriptor);
  DimensionDescriptor(const string &aname, const CTKVector &anaxis);
  ~DimensionDescriptor(){};

  const string& get_name() const;
  Integer get_index() const;
  Integer size() const;
  
  const CTKVector &get_axis() const;
  
  Boolean name_is(const string &aname) const;
  Boolean matches_size_of(DimensionDescriptor *dd) const;

  void set_index(Integer n);
  
private:
    
  DimensionDescriptor();

  DimensionDescriptor &operator=(const DimensionDescriptor &this_descriptor);
  
 
};


#endif

/* End of ctk_data_descriptor.hh */
