/******************************************************************************/
/*									      */
/*	ctk_differentiator.hh   			      			      */
/*									      */
/*	Class declarations for ctk_differentiator.cpp	               	      */
/*									      */
/*	Author: Jon Barker, Sheffield University			      */
/*									      */
/*      CTK VERSION 1.3.5  Apr 22, 2007			      */
/*									      */
/******************************************************************************/

#ifndef CTK_DIFFERENTIATOR_HH
#define CTK_DIFFERENTIATOR_HH

#include "ctk_block.hh"


const Integer	PARAM_DEFAULT_DELTA_WIN	= 2;


/******************************************************************************/
/*                                                                            */
/*       CLASS NAME: FrameBuffer                                              */
/*                                                                            */
/******************************************************************************/

class FrameBuffer {

private:

  int count_;
  int size_;
  
  vector<CTKVector*> buffer_;

public:
  
  FrameBuffer();
  ~FrameBuffer();

  int width() const;
  int size() const;
  
  const CTKVector & operator[](int i) const;
  void reset(int asize);
  void insert(CTKVector *vp);

  bool full() const;
  bool just_full() const;
  
};

///

float calc_delta_denominator(int win_size);

void process_input_vector(Socket *input_socket,
			  Socket *output_socket,
			  FrameBuffer &buffer,
			  CTKVector* process(const FrameBuffer &) );

CTKVector *construct_delta_vector(const FrameBuffer &buffer);
CTKVector *construct_delta_mask_vector(const FrameBuffer &buffer);
void construct_delta_bounds(const FrameBuffer &data_buffer, const FrameBuffer &mask_buffer,
			    const FrameBuffer &lower_bound_buffer, const FrameBuffer &upper_bound_buffer,
			    CTKVector * &delta_lbp, CTKVector * &delta_ubp);


/******************************************************************************/
/*                                                                            */
/*       CLASS NAME: DeltaBlock                                           */
/*                                                                            */
/******************************************************************************/

class DeltaBlock:public Block {

private:

  static const string type_name;
  static const string help_text;

  class ParamInt *DELTA_WIN_param;

  FrameBuffer frame_buffer;

  //
  //
 
public:

  DeltaBlock(const string &a_name);
  virtual ~DeltaBlock(){};

  virtual Block* clone(const string &new_name) const;

  virtual const string &get_helptext() const {return help_text;}

private:
  
  virtual void reset();
  virtual void compute();
  virtual void flush_buffer();
  virtual void close();

};

/******************************************************************************/
/*                                                                            */
/*       CLASS NAME: DeltaMaskBlock                                          */
/*                                                                            */
/******************************************************************************/

class DeltaMaskBlock:public Block {

private:
 
  static const string type_name;
  static const string help_text;
 
  class ParamInt *DELTA_WIN_param;

  FrameBuffer frame_buffer;

  //
  //
 
public:

  DeltaMaskBlock(const string &a_name);
  virtual ~DeltaMaskBlock(){};

  virtual Block* clone(const string &new_name) const;

  virtual const string &get_helptext() const {return help_text;}

  
private:
  
  virtual void reset();
  virtual void compute();
  virtual void flush_buffer();
  virtual void close();

};


/******************************************************************************/
/*                                                                            */
/*       CLASS NAME: BoundedDeltaBlock                                           */
/*                                                                            */
/******************************************************************************/

class BoundedDeltaBlock:public Block {

private:

  static const string type_name;
  static const string help_text;

  class ParamInt *DELTA_WIN_param;

  Integer width;

  CTKVector *delta_lbp, *delta_ubp;
  
  FrameBuffer data_buffer;
  FrameBuffer mask_buffer;
  FrameBuffer lower_bound_buffer;
  FrameBuffer upper_bound_buffer;
  
  //
  //
 
public:

  BoundedDeltaBlock(const string &a_name);
  virtual ~BoundedDeltaBlock(){};

  virtual Block* clone(const string &new_name) const;

  virtual const string &get_helptext() const {return help_text;}

private:
  
  virtual void reset();
  virtual void compute();
  virtual void flush_buffer();
  virtual void close();

};

#endif


/* End of ctk_differentiator.hh */
