/******************************************************************************/
/*									      */
/*	ctk_gammatone_bank.hh   					      */
/*									      */
/*	Class declarations for ctk_gammatone_bank.cpp            	      */
/*									      */
/*	Authors: Jon Barker, Sheffield University			      */
/*  	         Martin Cooke, Sheffield University			      */
/*									      */
/*      CTK VERSION 1.3.5  Apr 22, 2007			              */
/*      Modified by Martin from ctk_gammatone_bank to add                     */
/*      instantaneous frequency                                               */
/*									      */
/******************************************************************************/

#ifndef CTK_GAMMATONE_BANK_HH
#define CTK_GAMMATONE_BANK_HH

#include "ctk_block.hh"

// Have tried compiling GammaToneFloat set to float but it seems the filters become unstable
typedef double GammaToneFloat;
typedef vector<GammaToneFloat> GammaToneVector;

/******************************************************************************/
/*                                                                            */
/*       CLASS NAME: GammatoneBankBlock                                     */
/*                                                                            */
/******************************************************************************/

const Float	PARAM_DEFAULT_LOWER	= 50.0;
const Float     PARAM_DEFAULT_UPPER        = 5000.0;
const Integer   PARAM_DEFAULT_NUM_CHANS       = 64;

class GammatoneBankBlock:public Block {

private:

  static const string type_name;
  static const string help_text;
  static const string PARAM_DEFAULT_SCALE;

    class ParamInt *NUM_CHANS_param;
    class ParamFloat *LOWER_param;
    class ParamFloat *UPPER_param;
    class ParamEnumerated *SCALE_param;  // The type of scale to use  - i.e. ERB, MEL, LINEAR 

    Boolean bm_connected;
    Boolean env_connected;
    Boolean if_connected;
    Boolean am_connected;

    GammaToneVector a1, a2, a3, a4, a5;
    GammaToneVector p0, p1, p2, p3, p4;
    GammaToneVector q0, q1, q2, q3, q4;
    GammaToneVector denv0, denv1, denv2, denv3, denv4;
    GammaToneVector env1, env2, env3, env4;
    GammaToneVector cosine, sine, cos_ptr;  
    CTKVector cf;
    GammaToneVector gain;
    GammaToneFloat two_pi_t; 
    int sample;


    CTKVector bpa;
    CTKVector bpb;

    GammaToneFloat samplerate;
    CTKVector lastam, zct0;
  
public:

  GammatoneBankBlock(const string &a_name);
  virtual ~GammatoneBankBlock(){};

  virtual Block* clone(const string &new_name) const;

  virtual const string &get_helptext() const {return help_text;}

private:

  virtual void reset();

  virtual void build_output_data_descriptors();

  virtual void compute();


};


#endif

/* End of ctk_gammatone_bank.hh */
