/******************************************************************************/
/*									      */
/*	ctk_harmonic_removal.hh   		      			      */
/*									      */
/*	Class declarations for ctk_harmonic_removal.cpp	               	      */
/*									      */
/*	Author: Jon Barker, Sheffield University			      */
/*									      */
/*      CTK VERSION 1.3.5  Apr 22, 2007			      */
/*									      */
/******************************************************************************/

#ifndef CTK_HARMONIC_REMOVAL_HH
#define CTK_HARMONIC_REMOVAL_HH

#include "ctk_block.hh"

/******************************************************************************/
/*                                                                            */
/*       CLASS NAME: HarmonicRemovalBlock                                     */
/*                                                                            */
/******************************************************************************/

class HarmonicRemovalBlock:public Block {

private:

  static const string type_name;
  static const string help_text;

  class ParamInt *FACTOR_param;

  Integer maxfactor;
  Boolean do_nothing;
  
public:

  HarmonicRemovalBlock(const string &a_name);
  virtual ~HarmonicRemovalBlock(){};

  virtual Block* clone(const string &new_name) const;

  virtual const string &get_helptext() const {return help_text;}

private:

  virtual void reset();
  virtual void compute();
};

#endif

/* End of ctk_harmonic_removal.hh */
