/******************************************************************************/
/*									      */
/*	ctk_help_text.hh	    			       		      */
/*									      */
/*	Brief `what's this' style help messages for each CTK inbuilt block    */
/*									      */
/*	Author: Jon Barker, Sheffield University			      */
/*									      */
/*      CTK VERSION 1.3.5  Apr 22, 2007			              */
/*									      */
/******************************************************************************/

#ifndef CTK_HELP_TEXT_HH
#define CTK_HELP_TEXT_HH

/*****************  DEFAULT TEXT ************************************************************/

static const char * const BLOCK_HELP_TEXT=
"Sorry, no documentation available for this block.";

static const char * const SOURCE_BLOCK_HELP_TEXT=
"This block generates a signal.";

/***************** File Input and Output ****************************************************/

static const char * const BINARY_INPUT_FILE_BLOCK_HELP_TEXT=
"Binary input file";

static const char * const ASCII_INPUT_FILE_BLOCK_HELP_TEXT=
"ASCII input file";

static const char * const AU_SAMPLE_INPUT_FILE_BLOCK_HELP_TEXT=
"AU input file";

static const char * const RESPITE_INPUT_FILE_BLOCK_HELP_TEXT=
"RESPITE format input file";

static const char * const HTK_SAMPLE_INPUT_FILE_BLOCK_HELP_TEXT=
"HTK input file";

static const char * const TIMIT_SAMPLE_INPUT_FILE_BLOCK_HELP_TEXT=
"TIMIT input file";

static const char * const NIST_SAMPLE_INPUT_FILE_BLOCK_HELP_TEXT=
"NIST input file";

static const char * const BINARY_OUTPUT_FILE_BLOCK_HELP_TEXT=
"Binary output file";

static const char * const ASCII_OUTPUT_FILE_BLOCK_HELP_TEXT=
"ASCII output file";

static const char * const AU_SAMPLE_OUTPUT_FILE_BLOCK_HELP_TEXT=
"AU output file";

static const char * const RESPITE_OUTPUT_FILE_BLOCK_HELP_TEXT=
"RESPITE format output file";

static const char * const HTK_SAMPLE_OUTPUT_FILE_BLOCK_HELP_TEXT=
"HTK output file";

/***************** Signal Generators ********************************************************/

static const char * const CONSTANT_BLOCK_HELP_TEXT=
"Generates a constant signal of given amplitude";

static const char * const IMPULSE_WAVE_BLOCK_HELP_TEXT=
"Generates a series of impulses";

static const char * const SINE_WAVE_BLOCK_HELP_TEXT=
"Generates a sine wave";

static const char * const SQUARE_WAVE_BLOCK_HELP_TEXT=
"Generates a square wave";

static const char * const TRIANGLE_WAVE_BLOCK_HELP_TEXT=
"Generates a triangle wave";

static const char * const SAWTOOTH_WAVE_BLOCK_HELP_TEXT=
"Generates a sawtooth wave";

static const char * const GLOTTAL_WAVE_BLOCK_HELP_TEXT=
"Generates a rectilinear approximation to a glottal pulse";

static const char * const WHITE_NOISE_BLOCK_HELP_TEXT=
"Generates uniformly distributed white noise";

static const char * const GAUSSIAN_NOISE_BLOCK_HELP_TEXT=
"Generates Gaussian white noise";

static const char * const PINK_NOISE_BLOCK_HELP_TEXT=
"Generates noise with equal energy per octave";

static const char * const RAMP_BLOCK_HELP_TEXT=
"Generates a ramp";


/***************** Unary Operators **********************************************************/

// No parameters

static const char * const HALFWAVE_RECTIFY_BLOCK_HELP_TEXT=
"Half wave rectification";

static const char * const FULLWAVE_RECTIFY_BLOCK_HELP_TEXT=
"Full wave rectification";

static const char * const AMPTODB_BLOCK_HELP_TEXT=
"Converts amplitude to DB";

static const char * const DBTOAMP_BLOCK_HELP_TEXT=
"Converts DB to amplitude";

static const char * const LOG10_BLOCK_HELP_TEXT=
"Log10";

static const char * const LOG_BLOCK_HELP_TEXT=
"Natural log";

static const char * const EXP_BLOCK_HELP_TEXT=
"Exponential";

static const char * const LOGICAL_NOT_BLOCK_HELP_TEXT=
"NOT";

static const char * const SIN_BLOCK_HELP_TEXT=
"sine";

static const char * const COS_BLOCK_HELP_TEXT=
"cosine";

static const char * const TAN_BLOCK_HELP_TEXT=
"tangent";


static const char * const ASIN_BLOCK_HELP_TEXT=
"arc sine";

static const char * const ACOS_BLOCK_HELP_TEXT=
"arc cosine";

static const char * const ATAN_BLOCK_HELP_TEXT=
"arc tangent";


static const char * const SINH_BLOCK_HELP_TEXT=
"hyperbolic sine";

static const char * const COSH_BLOCK_HELP_TEXT=
"hyperbolic cosine";

static const char * const TANH_BLOCK_HELP_TEXT=
"hyperbolic tangent";


// One parameter

static const char * const FLOOR_BLOCK_HELP_TEXT=
"Set a lower bound of X";

static const char * const CEILING_BLOCK_HELP_TEXT=
"Set an upper bound of X";

static const char * const SCALE_BLOCK_HELP_TEXT=
"Multiply the signal by X";

static const char * const OFFSET_BLOCK_HELP_TEXT=
"Add X to the signal";

static const char * const POWER_BLOCK_HELP_TEXT=
"Raise the signal to the power of X";

static const char * const SIGMOID_BLOCK_HELP_TEXT=
"Sigmoid (with parameter X) i.e. y=1.0/(1.0+exp(-X*x))";

static const char * const GREATER_THAN_X_BLOCK_HELP_TEXT=
"Outputs TRUE if input is greater than parameter X, else it outputs FALSE";

static const char * const LESS_THAN_X_BLOCK_HELP_TEXT=
"Outputs TRUE if input is less than parameter X, else it outputs FALSE";

static const char * const EQUAL_TO_X_BLOCK_HELP_TEXT=
"Outputs TRUE if input is equal to the parameter X, else it outputs FALSE";

static const char * const NOT_EQUAL_TO_X_BLOCK_HELP_TEXT=
"Outputs TRUE if input is *not* equal to the parameter X, else it outputs FALSE";

static const char * const FIX_BLOCK_HELP_TEXT=
"Replaces occurrences of NaN in the input stream with the value given by the parameter X";

// Two parameters

static const char * const NORMAL_PDF_BLOCK_HELP_TEXT=
"output=p(input)  where p() is pdf for a normal distribution with a given mean and variance.";

static const char * const ERF_BLOCK_HELP_TEXT=
"The error function for a normal distribution of given mean and variance  (i.e. the integral between -inf and x).";

/***************** Binary Operators *********************************************************/

static const char * const COMPARATOR_BLOCK_HELP_TEXT=
"Output TRUE if the signal at the +ve terminal (in1) is greater than the signal at the -ve terminal (in2), else output FALSE ";

static const char * const DIVIDER_BLOCK_HELP_TEXT=
"Divide the numerator signal (in1) by the denominator signal (in2)";

/***************** Data Stream Merging and Splitting ****************************************/

static const char * const ADDER_BLOCK_HELP_TEXT=
"Sum all the input signals";

static const char * const MULTIPLIER_BLOCK_HELP_TEXT=
"Calculate the product of the input signals";

static const char * const LOGICAL_AND_BLOCK_HELP_TEXT=
"The output is the logical AND of the input signals";

static const char * const LOGICAL_OR_BLOCK_HELP_TEXT=
"The output is the logical OR of the input signals";

static const char * const MAX_BLOCK_HELP_TEXT=
"The output is the max of the input signals";

static const char * const MIN_BLOCK_HELP_TEXT=
"The output is the min of the input signals";

static const char * const TEE_BLOCK_HELP_TEXT=
"Produce multiple copies of the input signal";

static const char * const JOIN_BLOCK_HELP_TEXT=
"Join the inputs into a single wide stream";

static const char * const OPTION_BLOCK_HELP_TEXT=
"If the optional input2 is not connected then input1 is copied to the output; if the optional input2 is connected then it will be copied to the output instead.";

static const char * const SPLIT_BLOCK_HELP_TEXT=
"Split a stream into several narrower output streams";

/***************** Miscellaneous Operations *************************************************/

static const char * const FRAME_BLOCK_HELP_TEXT=
"Increases the dimensionality of the input";  

static const char * const FFT_BLOCK_HELP_TEXT=
"Produce an FFT on the input frames";  

static const char * const AVERAGER_BLOCK_HELP_TEXT=
"Reduce the dimensionality of the input by averaging over one of its axes"; 

static const char * const REDUCER_BLOCK_HELP_TEXT=
"Reduce the dimensionality of the input by fixing the value on one of its axes"; 

static const char * const SUM_BLOCK_HELP_TEXT=
"Reduce the dimensionality of the input by summing over on of its axes"; 

static const char * const PEAK_BLOCK_HELP_TEXT=
"Outputs the value and the index of the first peak (i.e. the peak with the lowest index) in the input vector"; 

static const char * const FIND_MAX_BLOCK_HELP_TEXT=
"Outputs the value and the index of the maximum valued element in the input vector"; 

static const char * const FIND_MIN_BLOCK_HELP_TEXT=
"Outputs the value and the index of the minimum valued element in the input vector"; 

static const char * const DECIMATOR_BLOCK_HELP_TEXT=
"Downsample by outputing every Nth frame that is input"; 

static const char * const UPSAMPLE_BLOCK_HELP_TEXT=
"Increase the sampling rate by an integer multiple. This is performed simply by repeating each input frame the required number of times (i.e. no linear interpolation or smoothing)."; 

static const char * const DELTA_BLOCK_HELP_TEXT=
"Calculate difference features using linear regression over a short window";  

static const char * const BOUNDED_DELTA_BLOCK_HELP_TEXT=
"Calculate difference features using linear regression over a short window. If a missing data mask and a set of missing data bounds are supplied, then the block will also calculate the mask and bounds for the delta features.";  

static const char * const DELTA_MASK_BLOCK_HELP_TEXT=
"Convert a missing data mask fpr static features into a missing data mask for delta features."; 

static const char * const FILTER_BLOCK_HELP_TEXT=
"  a(1)*y(n) = b(1)*x(n) + b(2)*x(n-1) + ... + b(nb+1)*x(n-nb)<p>- a(2)*y(n-1) - ... - a(na+1)*y(n-na) <p>If a(1) is not equal to 1, FILTER normalizes the filter coefficients by a(1). ";
 
static const char * const INTEGRATOR_BLOCK_HELP_TEXT=
"Integrate the input signal";  

static const char * const LEAKY_INTEGRATOR_BLOCK_HELP_TEXT=
"Leaky integration of the input signal with a given time constant"; 

static const char * const DELAY_BLOCK_HELP_TEXT=
"Delay the input signal by a given number of frames before outputting";  

static const char * const OUPUT_BLOCK_HELP_TEXT=
"Output to the console";  

static const char * const GAMMATONE_BANK_BLOCK_HELP_TEXT=
"Gammatone filter bank. There are four outputs: <p><b>out1</b> for the instantaneous envelope, <p><b>out2</b> for the basilar membrane displacement, <p><b>out3</b> for the instantaneous frequency, <p><b>out4</b> the AM frequency.";

static const char * const AUTOCORRELATOR_BLOCK_HELP_TEXT=
"Autocorrelation"; 

static const char * const HARMONIC_REMOVAL_BLOCK_HELP_TEXT=
"Harmonic removal. An alogorithm for postprocess summary autocorrelograms to remove peaks occurring at multiples of the fundamental."; 

static const char * const MEDDIS_HAIRCELL_BLOCK_HELP_TEXT=
"Meddis hair cell model";

static const char * const LINDEMANN_LOCALISATION_BLOCK_HELP_TEXT=
"Lindemann localisation model. WARNING: This implementation has not been tested.";

static const char * const COLOUR_MASK_BLOCK_HELP_TEXT=
"Takes a 1/0 missing data mask and produces a simple group labeling";

static const char * const GROUP_START_END_DETECTION_BLOCK_HELP_TEXT=
"Outputs the labels of groups that are starting and ending";

static const char * const MERGE_GROUPS_BLOCK_HELP_TEXT=
"Takes two groups labelings and produces a single group labeling that is consistent with both based. The output will be the smallest set of groups for which both of the two inputs are a subset.";

static const char * const CUT_GROUPS_BLOCK_HELP_TEXT=
"Takes a group labeling and a boolean 'cutting signal' and cuts the groups at frames at which the cutting signal changes state. ";

static const char * const PRUNE_GROUPS_BLOCK_HELP_TEXT=
"Remove groups beneath a minimum size ";



/***************** Noise Estimation and Spectral Subtraction ********************************/


static const char * const STATIONARY_NOISE_ESTIMATION_BLOCK_HELP_TEXT=
"Stationary noise estimation. To be applied to spectral data. There are two outputs: out1, is the estimated noise spectra, and out2 is the estimated signal spectrum (i.e. the result of subtracting the estimated noise spectrum from the noisy spectrum).";

static const char * const HIRSCH_WA_NOISE_ESTIMATION_BLOCK_HELP_TEXT=
"Hirsh weighted-average noise estimation. To be applied to spectral data. There are two outputs: out1, is the estimated noise spectra, and out2 is the estimated signal spectrum (i.e. the result of subtracting the estimated noise spectrum from the noisy spectrum).";


/***************** Matlab Interface *********************************************************/


static const char * const MINPUT_BLOCK_HELP_TEXT=
"For reading data from the MATLAB data space";

static const char * const MOUTPUT_BLOCK_HELP_TEXT=
"For writing data to the MATLAB data space";

static const char * const MDISPLAY_BLOCK_HELP_TEXT=
"For displaying data using MATLAB. Note, the data is also written to the MATLAB data space.";

static const char * const MPROCESS_BLOCK_HELP_TEXT=
"For inserting a MATLAB process in a CTK system.";


/***************** Graphical Display *********************************************************/


static const char * const DISPLAY_BLOCK_HELP_TEXT=
"Produces a graph of the data";

/***************** HMM Decoders *********************************************************/

static const char * const HMM_DECODER_ONLY_BLOCK_HELP_TEXT=
"Conventional HMM decoder. Decoder only, i.e. supplied directly with state likelihoods";

static const char * const HMM_DECODER_STANDARD_BLOCK_HELP_TEXT=
"Conventional HMM decoder.";

static const char * const HMM_DECODER_MD_BLOCK_HELP_TEXT=
"HMM decoder adapted for missing data. <p>There are four inputs: <p> <b>in1</b> for the features, <p> <b>in2</b> for the missing data mask, <p> <b>in3</b> is for the missing data lower bounds (optional). <p> <b>in4</b> is for the missing data upper bounds (optional).";

static const char * const HMM_DECODER_UDBOUNDS_BLOCK_HELP_TEXT=
"An experimental HMM decoder adapted for <b>probabilistic</b> MD masks. <p>There are three inputs: <p> <b>in1</b> for the features, <p> <b>in2</b> for the probabilistic missing data mask, <p> <b>in3</b> is for the missing data upper bounds.";


static const char * const HMM_DECODER_PMC_BLOCK_HELP_TEXT=
".";

static const char * const PHMM_DECODER_MD_BLOCK_HELP_TEXT=
".";

static const char * const HMM_DECODER_MULTISOURCE_BLOCK_HELP_TEXT=
"The Multisource (aka CASA) Decoder designed to operate with discrete masks.<p> There are four inputs:  <p> <b>in1</b> for the features, <p> <b>in2</b> for the probabilistic missing data mask, <p> <b>in3</b> for the group tags, <p> <b>in4</b> is for the missing data upper bounds.";


static const char * const HMM_DECODER_MULTISOURCE_SOFT_BLOCK_HELP_TEXT=
"The Multisource (aka CASA) Decoder designed to operate with soft masks.<p> There are four inputs:  <p> <b>in1</b> for the features, <p> <b>in2</b> for the probabilistic missing data mask, <p> <b>in3</b> for the group tags, <p> <b>in4</b> is for the missing data upper bounds.";


#endif

/* End of ctk_help_text.hh */
