/******************************************************************************/
/*									      */
/*	ctk_matlab.hh   			             		      */
/*									      */
/*	Class declarations for ctk_matlab.cpp  	                 	      */
/*									      */
/*	Author: Jon Barker, Sheffield University			      */
/*      updated by Sue Harding                                                */
/*									      */
/*      CTK VERSION 1.3.5  Apr 22, 2007			      */
/*									      */
/******************************************************************************/

#ifndef CTK_MATLAB_HH
#define CTK_MATLAB_HH

#include "ctk_block.hh"


/******************************************************************************/
/*                                                                            */
/*       CLASS NAME: MatlabInputBlock                                         */
/*                                                                            */
/******************************************************************************/

const Integer MATLAB_BUFFER_CHUNK_SIZE = 64;

#ifdef _HAS_MATLAB

class MatlabInputBlock:public SourceBlock {

private:

  static const string type_name;
  static const string help_text;

  class ParamString *NAME_param;

  class ParamInt *num_samples_param;
  
  Integer index;
  Boolean is_sample_data;
  
  CTKVector sample_buffer;
  vector<CTKVector*> vector_buffer;
  

public:

  MatlabInputBlock(const string &a_name);
  virtual ~MatlabInputBlock();

  virtual Block* clone(const string &new_name) const;

  virtual const string &get_helptext() const {return help_text;}

private:

  virtual void reset();  
  virtual void build_output_data_descriptors();
  virtual void compute();

  void free_storage();
};

#endif

/******************************************************************************/
/*                                                                            */
/*       CLASS NAME: MatlabOutputBaseBlock                                    */
/*                                                                            */
/******************************************************************************/

const Integer	PARAM_DEFAULT_DISPLAY	=  true;
const char PARAM_DEFAULT_1D_PLOT[] = "h=plot(%);";
const char PARAM_DEFAULT_2D_PLOT[] = "h=imagesc(%); axis xy;";

class MatlabOutputBaseBlock:public Block {

private:
  
  class ParamString *NAME_param;
  class ParamBool   *DISPLAY_param;   // if TRUE then display, else data just passses through undisplayed
  class ParamBool   *SHOW_MATLAB_param;   // if TRUE then show the Matlab commands to be executed
					  // (added by Sue 28.5.03)

  Boolean output_connected;

  vector<Float> sample_buffer;

protected:	// added by Sue for MatlabDisplayFrameBlock - used in output_data

  class ParamString *PLOT_param;      // String for making a customised plot

  vector<CTKVector*> vector_buffer;
  
  // added by Sue 12.5.03 for MatlabDisplayFrameBlock
  string title_name;	// name used for title (based on NAME parameter)
  string matlab_name;	// name of Matlab variable (based on NAME parameter)

public:

  MatlabOutputBaseBlock(const string &a_name, const string &a_type);
  virtual ~MatlabOutputBaseBlock();

  virtual Block* clone(const string &new_name) const=0;


  
protected:

  virtual void reset();
  
  virtual void compute();

  virtual void free_storage();

  virtual void close();

  Boolean get_DISPLAY_param_value();
  Boolean get_SHOW_MATLAB_param_value();
  
#ifdef _HAS_MATLAB
  virtual void output_data(Boolean make_plot);
  // added by Sue 12.5.03 for MatlabDisplayFrameBlock
  virtual void make_var_names(); // create names of variables
#endif
};

/******************************************************************************/
/*                                                                            */
/*       CLASS NAME: MatlabDisplayBlock                                       */
/*                                                                            */
/******************************************************************************/

class MatlabDisplayBlock:public MatlabOutputBaseBlock {

  static const string type_name;
  static const string help_text;

  class ParamString *BEFORE_PLOT_param;
  class ParamString *AFTER_PLOT_param;
  
public:

  MatlabDisplayBlock(const string &a_name);
  virtual ~MatlabDisplayBlock();

  virtual Block* clone(const string &new_name) const;

  virtual const string &get_helptext() const {return help_text;}

private:
  
  virtual void reset();
  virtual void close();
};



/******************************************************************************/
/*                                                                            */
/*       CLASS NAME: MatlabDisplayFrameBlock  - Sue Harding                   */
/*                                                                            */
/******************************************************************************/

const char PARAM_DEFAULT_3D_PLOT[] = "h=imagesc(%); axis xy;";

class MatlabDisplayFrameBlock:public MatlabOutputBaseBlock {

  static const string type_name;
  static const string help_text;

private:
  
  // Parameters for 3-D plots
  class ParamString *XAXIS_param;	// Input dimension to use as X axis
  class ParamString *FRAMELIST_param;	// List of frames to display

  // Extra Matlab commands to perform... //
  class ParamString *BEFORE_EACH_FRAME_param;	// ...before each frame is displayed
  class ParamString *AFTER_EACH_FRAME_param;	// ...after each frame is displayed

  class ParamString *BEFORE_PLOT_param;	// ...before any frame is displayed
  class ParamString *AFTER_PLOT_param;	// ...after all frames are displayed


  
public:

  MatlabDisplayFrameBlock(const string &a_name);
  virtual ~MatlabDisplayFrameBlock();

  virtual Block* clone(const string &new_name) const;

  virtual const string &get_helptext() const {return help_text;}

private:
  
  virtual void reset();
  virtual void close();

#ifdef _HAS_MATLAB
  virtual void output_data(Boolean make_plot);
#endif

};


/******************************************************************************/
/*                                                                            */
/*       CLASS NAME: MatlabOutputBlock                                        */
/*                                                                            */
/******************************************************************************/

#ifdef _HAS_MATLAB

class MatlabOutputBlock:public MatlabOutputBaseBlock {

  static const string type_name;
  static const string help_text;

public:

  MatlabOutputBlock(const string &a_name);
  virtual ~MatlabOutputBlock();

  virtual Block* clone(const string &new_name) const;

  virtual const string &get_helptext() const {return help_text;}

private:
  
  virtual void reset();
  virtual void close();
};

#endif

/******************************************************************************/
/*                                                                            */
/*       CLASS NAME: MatlabProcessBlock                                       */
/*                                                                            */
/******************************************************************************/

#ifdef _HAS_MATLAB

class MatlabProcessBlock:public Block {

private:
  
  static const string type_name;
  static const string help_text;

  mxArray *mx_in[100];

  string input_string, output_string;
  string do_initialise;
  string do_process;
  
  class ParamString *INITIALISE_param;
  class ParamString *PROCESS_param;

public:

  MatlabProcessBlock(const string &a_name);
  virtual ~MatlabProcessBlock(){};

  virtual Block* clone(const string &new_name) const;

  virtual const string &get_helptext() const {return help_text;}
  
private:

  virtual void reset();
  virtual void build_output_data_descriptors();
  
  virtual void compute();

  
  //
  // Stuff for manipulating the process and initialisation strings
  //
  
  void variable_name_uniquification(string &initialise, string &process, string uniq);
  void remove_unwanted_equals_signs(string &line);
  void replace_name(string &line, string from_name, string to_name);
  
};

#endif  // _HAS_MATLAB

#endif


/* End of ctk_matlab.hh */
