/******************************************************************************/
/*									      */
/*	ctk_shell.hh	        					      */
/*									      */
/*	Class declarations for ctk_shell.cpp		        	      */
/*									      */
/*	Author: Jon Barker, Sheffield University			      */
/*									      */
/*      CTK VERSION 1.3.5  Apr 22, 2007			      */
/*									      */
/******************************************************************************/

#ifndef CTK_SHELL_HH
#define CTK_SHELL_HH

#include <string>
#include <vector>

#include "ctk_local.hh"

/** Necessary forward declarations */

class Block;
class CTK_Shell;
class CTKScriptElement;

/******************************************************************************/
/*									      */
/*	CLASS NAME: CTK_Shell	         				      */
/*									      */
/******************************************************************************/

typedef struct _win_st WINDOW;

class CTK_Shell {
private:

#ifdef _HAS_CURSES
  WINDOW *window;           // curses window pointer for interactive shells
#endif

  std::istream *istr;

  Boolean runtime_profiling;  // If true blocks are run with runtime profiling
  Boolean is_interactive;   // True for interactive shells

  char *prompt;             // The prompt string.
  
  UInteger x,y;              // Current cursor position 
  UInteger maxx, maxy;       // Terminal dimensions
  string buffer;                       // The line being editted
  string::iterator bufferp;            // Current insert point in the line buffer
  string match_buffer;      // String to match on when searching the command history
  vector <string> history;  // The command history
  vector <string>::iterator historyp;  // Current search point in the command history
  UInteger length;                          // The current length of the line

  //
  //
  //
  
public:
  CTK_Shell(istream *this_istr, Boolean interactive=false);
  ~CTK_Shell();

  Integer run();
  
  void do_main(int argc, const char* argv[]);

#ifdef _HAS_MATLAB
  void do_matlab(const char *command);
#endif
  
  void do_unix(const char *command);

  void set_runtime_profiling(Boolean x); // Turn runtime profiling on or off
  void toggle_runtime_profiling();    // Toggles runtime profiling switch
  
private:

#ifdef _HAS_CURSES

  // Methods for interactive shells

  void initialise_terminal(const char *a_prompt);
  void exit_terminal();
  string get_command();                                  // Get a commandline from the user
  void replace_line(const char *new_line, const char *prompt); // Replace the contents of the edit line
  CTKStatus CTK_Shell::search_back(vector<string>::iterator &back);        // Search back through command history
  CTKStatus CTK_Shell::search_forward(vector<string>::iterator &back);      // Search forward through command history
  
#endif
  

};

#endif

/* End of ctk_shell.hh */
