/******************************************************************************/
/*									      */
/*	ctk_example.cpp	        	       			              */
/*									      */
/*	[very short description of block functionality here]                  */
/*									      */
/*	Author: [AUTHORNAME]                    			      */
/*									      */
/*      CTK VERSION [VERSION]  [DATE]    		         	      */
/*									      */
/******************************************************************************/

// Replace all occurances of the word "example" with the name of the new block
// you are writing.  


// Any required STL include file 
#include <cmath>
#include <vector>

// ctk_local.hh should be included for all CTK blocks
// This provides types, Integer, Float, etc which should be used rather than
// int, float etc

#include "ctk_local.hh"

// Other ctk headers.

#include "ctk_socket.hh"  // ... always required.

// The following is the list of the most useful headers. Add as required:

// #include "ctk_param.hh"             // ... required for all blocks that have parameters
// #include "ctk_data_descriptor.hh"   // ... required for blocks that act on the data descriptors
// #include "ctk_dsp.hh"               // ... some general signal processing code e.g FFT, hanning windows
// #include "ctk_auditory.hh"          // ... some auditory processing code.  e.g. ERB to Hz conversion

// Finally, remember the header file containing declarations for this block.

#include "ctk_example.hh"  

#include <string.h>

/******************************************************************************/
/*                                                                            */
/*       CLASS NAME: ExampleBlock                                             */
/*                                                                            */
/******************************************************************************/

// Definition of help_text - as used e.g. in the GUI interface.
const string ExampleBlock::help_text =
"Add a short help text string here. This will be used to display help in the Qt GUI."
"Certain HTML like formatting tags are available, e.g. <b>bold</b>, <p> new paragraph etc"
"See Qt documentation http://doc.trolltech.com/qstylesheet.htm for more."


// The constructor. Must always be present.

ExampleBlock::ExampleBlock(const string &a_name):CTKObject(a_name),Block(a_name, "Example") {

  // Declare the number of inputs and outputs e.g. for one input, and one output.
  make_input_sockets(1);  
  make_output_sockets(1);

  // If you want a block with a variable number of inputs and/or outputs, add TRUE as a second param e.g:
  //   make_input_sockets(1, TRUE)
  //   make_output_sockets(1, TRUE)
  // In this case, the first param is the just default number of inputs/outputs, and may be changed by the
  // user i.e. by setting the NINPUTS/NOUTPUTS variables in the scripts, or via the parameter panels in the
  // CTK GUI
  

  // Construct any user parameters that your block requires.
  // (When naming these, use the conventions used in the names below):
  
  MULTIPLE_param= new ParamInt("MULTIPLE");             // This declares an integer parameter
  OUTPUT_RATE_param= new ParamFloat("OUTPUT_RATE");     // This declares a floating point parameter

  // If you have default values for your parameters, these are added as a second argument to the constructor:

  //  MULTIPLE_param= new ParamInt("MULTIPLE", PARAM_DEFAULT_DECIMATION_MULTIPLE);
  

  // Help text - which can be accessed in the GUI can be supplied as shown here:
  MULTIPLE_param->set_helptext("An integer multiple by which to decimate the input signal. <p> Either MULTIPLE or OUTPUT_RATE may be set, but not both.");
  OUTPUT_RATE_param->set_helptext("The desired output sample rate.<p> The input is decimated by the integer multiple which produces an output sample rate closest to the desired value. <p>Either MULTIPLE or OUTPUT_RATE may be set, but not both.");
  
  // Units (or useful notes) to appear on the GUI parameter panel can be supplied like:
  OUTPUT_RATE_param->set_unit("Hz");

  
  // Once constructed, the parameters must be registered. This is done as below:
  parameters->register_parameter(MULTIPLE_param);
  parameters->register_parameter(OUTPUT_RATE_param);

  // Note, these two parameters have been registered as Settable and  Visible and Non-Transmitted.
  // These are the appropriate attributes for nearly all parameters. If necessary the parameter
  // can be registered with different attributes by constructing a second argument for
  // register_parameter() from the logical-OR of the following constants,
  //   CTK_PARAM_TYPE_CONST, CTK_PARAM_TYPE_HIDDEN, CTK_PARAM_TYPE_TRANSMITTED, e.g.
  //   parameters->register_parameter(OUTPUT_RATE_param, CTK_PARM_TYPE_CONST)
}


// The destructor. Close files, delete objects that have been created etc.
ExampleBlock::~ExampleBlock() {
}


// The "virtual constructor", clone()
//
// This MUST be present exactly as below (except for the class name!) for ALL blocks:

Block* ExampleBlock::clone(const string &n) const{
  Block *ablock = new ExampleBlock(n.empty()?getname():n);
  return copy_this_block_to(ablock);
}


// All classes inheritting from Block or SourceBlock have the following 5 virtual methods that they may need to reimplement.
// 1. reset()                         - often needs reimplementing
// 2. build_output_data_descriptors() - occasionally needs reimplementing
// 3. compute()                       - must *always* be reimplemented
// 4. close()                         - often needs reimplementing
// 5. close_final()                   - occasionally needs reimplementing



// 1. The reset() method.
//
// The reset() method is called once for each block in the block network and is
// called immediately before the network is `run' - i.e. before the computation begins.
// reset() should perform the following tasks:
//    1.  Check that the input data type is compatible with the block
//    2.  Put any class variables used in compute into a good starting state.
//          e.g. a block that performs integration must reset the accumulator to 0.0.

// If the block is not fussy about the data type it accepts, and has no variables that need resetting
// then the reset() method need not be reimplemented.

void ExampleBlock::reset() {
  Block::reset();   // always start by calling the parent class' reset()
  
  // Note, for input blocks the parent class will be SourceBlock and the line above should be:
  //   SourceBlock::reset();

  // Add stuff here...
}




// 2. The build_output_data_descriptor() method.
//
// This method is called immediately after reset() but before the block is `run'.
// Its job is to write "data descriptors" for the output sockets. These are what tell the output sockets
// how the frames of data should be interpretted (i.e. their dimensionality etc). In many cases a block
// will operate on a frame of data without changing its format - in this case the default behaviour in
// Block::build_output_data_descriptors(), which just copies a data descriptor from the first input socket
// to all the outputs will be appropriate and the method does not have to be reimplemented.
// However, blocks that change any aspect of the data format - i.e. a block that increases the width of
// a frame of data, or adds a new dimension, or changes the axis of a dimension, must reimplement this
// method.
//
// The general structure of this method is something like:
// 1. First get the data descriptors from the input sockets - e.g.
// const DataDescriptor *idd = (*input_sockets)[0]->get_data_descriptor();
//
// 2. Use these input data descriptors to work out what sort of data the block will produce.
//
// 3. Construct new data descriptors for the output sockets. This may for example involve copying and
// modifying one of the input data descriptors e.g.
//   DataDescriptor *dd = new DataDescriptor(*idd);
//   const DimensionDescriptor *dimd = dd->get_outer_dimension();
//   axis=dimd->get_axis();
//   axis.resize(output_size);
//
// 4. Write the modified data descriptor to the output socket - e.g.
//    (*output_sockets)[0]->set_data_descriptor(dd);

void ExampleBlock::build_output_data_descriptors() {
  //
  // Add stuff in here...
}


// 3. The compute() method.
//
// This is the guts of the block and must always be implemented. This is what is called when the system is being "run."
// Compute will typically do something like:
//    1. Read 1 or more frames of data from the input sockets (if the block has any)
//    2. Process the data.
//    3. Write 1 or more frames of data to the output sockets (if the block has any)
//
// When writing compute() it is important to remember which data types (e.g. which data dimensionalities) are
// permitted for the block and make sure that all permitted types are catered for.
// Note, inappropriate input types should have been trapped during the reset() method. 

void ExampleBlock::compute() {
  //
  // Add stuff here...
}



// 4. The close() method
//
// close() is called once for each block in the network, immediately after computation has finished.
// The close() method can be used to free any resources that were allocated in reset().
// It is also used in methods like display(), where the compute() method simply buffers all the data passing
// through the block and then the code to generate the display is placed in close().

void ExampleBlock::close() {
  //
  // Add stuff here ...
  //
  
  Block::close();   // always end by calling the parent class' close()
  
  // Note, for input blocks the parent class will be SourceBlock and the line above should be:
  //   SourceBlock::close();

}


// 5. The close_final() method
//
// close_final() is called once for each block after the "parameter list loop" has completed.
// This means that if the user is using the parameter list mechanism to process a corpus, whereas
// close() is called after processing each entry in the corpus, close_final() is called just once
// after close() has been called on the final entry in the corpus().
//
// An example of where close_final() is needed, is in the HMMDecoderBlock class where it is used
// to write out the confusion matrix that is accumulated over the list of utterances being recognised.
//
// Few blocks need to reimplement this method. 

void ExampleBlock::close_final() {
  //
  // Add stuff here ...
  //

  Block::close_final();   // always end by calling the parent class' close_final()
  
  // Note, for input blocks the parent class will be SourceBlock and the line above should be:
  //   SourceBlock::close_final();

}

/* End of ctk_NEW_BLOCK_TEMPLATE.cpp */
 
