/******************************************************************************/
/*                                                                  	      */
/*     my_blocks.hh                                                	      */
/*                                                                    	      */
/*     Class declarations for my_blocks.cpp                                   */
/*                                                                    	      */
/*     Author: Jon Barker, Sheffield University                       	      */
/*                                                                    	      */
/*      CTK VERSION 1.3.5  Apr 22, 2007			      	      */
/*                                                                    	      */
/******************************************************************************/

// Some blocks provided to demonstrate how users can extend the toolkit - See $CTKROOT/local/notes.txt

#ifndef MY_BLOCKS_HH
#define MY_BLOCKS_HH

#include "ctk_block.hh"
#include "ctk_param.hh"

/******************************************************************************/
/*                                                                            */
/*       CLASS NAME: WindowBlock                                              */
/*                                                                            */
/******************************************************************************/

const Integer   	PARAM_DEFAULT_WINDOW_SHIFT	= 1;
const vector<Float>	PARAM_DEFAULT_WINDOW_WINDOW	= vector<Float>(1, 1.0);

class WindowBlock:public Block {

private:
  static const string help_text;

  ParamInt *SHIFT_param;
  ParamFloatVector *WINDOW_param;

   CTKVector data;
   Integer overlap;

  //
  //
  
public:

  WindowBlock(const string &a_name);

  Block* clone(const string &new_name) const;


private:

  void reset();

  void compute();


};


/******************************************************************************/
/*                                                                            */
/*       CLASS NAME: RampArrayBlock                                           */
/*                                                                            */
/******************************************************************************/

const Float	PARAM_DEFAULT_RAMPARRAY_START	= 0.0;
const Float	PARAM_DEFAULT_RAMPARRAY_STEP	= 1.0;

class RampArrayBlock:public SourceBlock {

private:
  static const string help_text;

  ParamFloat *START_param;
  ParamFloat *STEP_param;
  ParamInt   *N_param;
  
  Float data;

  //
  //
  
public:

  RampArrayBlock(const string &a_name);

  Block* clone(const string &new_name) const;


private:

  void reset();

  void compute();


};



/******************************************************************************/
/*                                                                            */
/*       CLASS NAME: OutputArrayBlock                                         */
/*                                                                            */
/******************************************************************************/


class OutputArrayBlock:public Block {

private:
  static const string help_text;

  //
  //
  
public:

  OutputArrayBlock(const string &a_name);

  Block* clone(const string &new_name) const;

  
private:

  void reset();

  void compute();


};

#endif

/* End of my_blocks.hh */
