/******************************************************************************/
/*                                                                  	      */
/*     my_translation_table.cpp                                        	      */
/*                                                                    	      */
/*     Translation table for user-supplied blocks                             */
/*                                                                    	      */
/*     Author: Jon Barker, Sheffield University                       	      */
/*                                                                    	      */
/*      CTK VERSION 1.3.5  Apr 22, 2007			      	      */
/*                                                                    	      */
/******************************************************************************/

#include "ctk-config.h"

#include <map>                     // The STL map container

#include "ctk_local.hh"             // Some essential CTK typedefs
#include "ctk_block.hh"             // The CTK Block class header
#include "my_block_headers.hh"      // Includes headers for ALL the user supplied blocks

void register_block(map<string, Block*> &translator, Block *b) {
  translator[b->get_blocktype()]=b;
}
 
// Insert a line in the my_translation_table() function for every block you want to add:
// 1. The string on the left is the name of the block as you want it to appear in the scripts and GUI
// 2. On the right should be the block's null constructor   i.e MyBlock("\0")

void my_translation_table(map<string, Block*> &translator) {
  // Translations for examples provided in standard distribution
  register_block(translator, new WindowBlock("\0"));       // delete if not wanted 
  register_block(translator, new RampArrayBlock("\0"));    // delete if not wanted
  register_block(translator, new OutputArrayBlock("\0"));  // delete if not wanted
  
  // Register your own blocks below here... e.g
  // register_block(translator, new MyThingBlock("\0"));
  
}

/* End of my_translation_table.cpp */
