/******************************************************************************/
/*									      */
/*	CTKScript.cpp	    						      */
/*									      */
/*	Read a block script and process block   			      */
/*	       								      */
/*	Author: Jon Barker, Sheffield University			      */
/*									      */
/*      CTK VERSION 1.3.5  Apr 22, 2007			      */
/*									      */
/******************************************************************************/

#include "ctk-config.h"

#include "ctk.hh"


void usage() {
  cout << "usage: CTKScript [-h] [-profile] [-param name=value] script_fil [-S $1_file]  [-S $2_file] ..." << endl;
  cout << "usage: CTKScript [-h] [-profile] [-param name=value] script_fil [$1] [$2] ..." << endl;
  exit(-1);
}

int main(int argc, char *argv[]) 
{
  CTK_Shell *shell=NULL;

  ReadOnceFile::interactive_mode_ = false;

    
  if (argc==1) {
    cout << CTK_VERSION_STRING << endl;
    exit(-1);
  }

  if (argc==2 && (strcmp(argv[1],"-h")==0||strcmp(argv[1],"-?")==0))
    usage();
  
    
  try {  
    shell=new CTK_Shell(&cin, false);  // false = non-interactive shell
    shell->do_main(argc, (const char**)argv);
#ifdef _HAS_MATLAB
    Block::matlab_shutdown();
#endif
  }    
  catch (CTKError &error) {
#ifdef _HAS_MATLAB
    Block::matlab_shutdown();
#endif
    cerr << "CTK EXCEPTION CAUGHT BY DEFAULT HANDLER" << endl;
    error.debug_print(); 
  }

  delete shell;
}




/* End of CTKScript.cpp */
