/******************************************************************************/
/*									      */
/*	ctk_gui.hh	        					      */
/*									      */
/*	Author: Jon Barker, Sheffield University			      */
/*									      */
/*      CTK VERSION 1.3.5  Apr 22, 2007  			      */
/*									      */
/******************************************************************************/

#ifndef CTK_GUI_HH
#define CTK_GUI_HH

#include <qdialog.h>
#include <qmainwindow.h>
#include <qscrollview.h>

class QLineEdit;
class QToolButton;

class LayoutFrame;
class BlockWidget;
class CentralWidget;
class ParameterListWidget;
class BlockProfileWidget;
class PreferencesWidget;
class CTKError;

/******************************************************************************/
/*									      */
/*	CLASS NAME: CTKScrollView	        			      */
/*									      */
/******************************************************************************/

class CTKScrollView : public QScrollView {

private:
  LayoutFrame *layout_frame;

  //
  //
  //
  
public:
  
  CTKScrollView(CentralWidget *parent, bool read_only=false);
  ~CTKScrollView();
  
  LayoutFrame *getLayoutFrame() const;

 
};



/******************************************************************************/
/*									      */
/*	CLASS NAME: CTKMainWindow		        	      	      */
/*									      */
/******************************************************************************/

class CTKMainWindow : public QMainWindow {
Q_OBJECT  

public:
  
static PreferencesWidget *preferencesw;

private:
  QToolBar *file_tools;
  QPrinter *printer;
  QStatusBar *status_bar;

  QPopupMenu *fileMenu;
  int fileMenuSaveID;

  QPopupMenu *editMenu;
  int editMenuUndoID;
  
  QPopupMenu *layoutMenu;
  int layoutMenuToggleGridID;
  int layoutMenuToggleSnapID;

  QPopupMenu *runMenu;
  int runMenuRunID;
  int runMenuRunWithID;
  int runMenuStopID;
  
  QPopupMenu *profileMenu;
  int profileMenuToggleProfileID;

  QToolButton *fileSaveButton;
  QToolButton *undoButton;
  QToolButton *startButton;
  QToolButton *stopButton;
  QToolButton *findButton;
  
  CentralWidget *central;

  bool trying_to_enter_shell;
  
  //
  //
  //
  
public:
  CTKMainWindow(QWidget *parent=0, const char* name=0, const char* ctk_file=0);
  ~CTKMainWindow();

  virtual void hideEvent ( QHideEvent * e);

  
public slots:

  void warningMessage(const QString &message);
  void statusMessage(const QString &message);
  void handleCTKError(CTKError &error, QString);
  void dirtyMessageSlot(bool is_dirty);
  void undoStatusHasChanged(bool undo_status);
  //  void readOnlyMessage(bool is_dirty);

private:
  void enterShell_partII();

private slots:
  int openCTKFile();
  void saveCTKFile();
  void saveAsCTKFile();
  void revertCTKFile();
  void toggleGrid();
  void toggleSnap();
  void toggleProfile();
  void resetProfile();
  void displayProfileReport();
  void newDoc();
  void enterShell();
  void print();
  void runSystem();
  void runSystemWith();
  void stopSystem();
  void quit();
  void about();
  void help();
  void undo();
  void find();
  void unselectAll();
  void preferences();



};

/******************************************************************************/
/*									      */
/*	CLASS NAME: GetCommandLineModal	                 	      	      */
/*									      */
/******************************************************************************/

class GetCommandLineModal : public QDialog {
Q_OBJECT  

private:

  QLineEdit *line_edit;
  
  int argc;
  char **argv;
  
public:
  GetCommandLineModal( QWidget *parent, QString name );

  int get_argc() const;
  char **get_argv() const;

private:
  void free_argv();
  void build_argv(QString text);
  
private slots:
void okClicked();
};


#endif


/* End of ctk_gui.hh */
