/******************************************************************************/
/*									      */
/*	ctk_gui_centralw.hh	        				      */
/*									      */
/*	Author: Jon Barker, Sheffield University			      */
/*									      */
/*      CTK VERSION 1.3.5  Apr 22, 2007  			      */
/*									      */
/******************************************************************************/

#ifndef CTK_GUI_CENTRALW_HH
#define CTK_GUI_CENTRALW_HH

#include <string>
#include <vector>
#include <map>

#include <qwidget.h>
#include <qstring.h>

#include "ctk_local.hh"
#include "ctk_block.hh"

class QTabWidget;
class QComboBox;
class QLabel;
class QPaintEvent;
class LayoutFrame;

class CTKError;

/******************************************************************************/
/*									      */
/*	CLASS NAME: CentralWidget		        	      	      */
/*									      */
/******************************************************************************/

class CentralWidget : public QWidget {
Q_OBJECT  
private:
  QComboBox* blocktype_button;
  QStringList *blocktypes;
  QTabWidget *tp;

  QString pulldown_blocktype;
  
  LayoutFrame *layout_frame;          // Active layout frame
  vector<LayoutFrame*> layout_list;   // List of all layout frames
  
  map<std::string, Block*> constructor_translator;

  Block *main_block;
  bool is_dirty;

  QLabel *dirty_status;
  QLabel *read_only_status;

  int block_no;

  class CTKReader *script;

  class Grid *grid;

  bool profile_switch;

  //
  //
  //
  
public:

  CentralWidget(QWidget* parent=0, const char* name=0);
  ~CentralWidget();

  LayoutFrame *selectLayoutPanel(const QString &name);   // Select the layoutPanel called name

  void paintEvent(QPaintEvent *e);
  
  CTKStatus loadCTKFile(const QString &block_file_name, Boolean called_from_revert = false);
  QString saveCTKFile();
  QString saveAsCTKFile(const QString &file_name=0);

  void toggleGrid();
  void toggleSnap();

  void undo();
  void find();
  void unselectAll();
  
  CTKStatus revertCTKFile();

  bool newDoc();
  void runSystem();
  void runSystemWith();
  void stopSystem();

  void toggleProfile();
  void resetProfile();
  void displayProfileReport();
  
  void makeBlocksAvailable(const BlockList &block_list);
  LayoutFrame *addScrollViewForBlock(Block *block, bool read_only, bool show_page=false);

  const LayoutFrame *getLayoutFrame() const {return layout_frame;}
  
  QString getUniqueBlockName();

  Grid *getGrid() const;

  bool getProfileSwitch() const {return profile_switch;}
  
  bool cleanUpBeforeQuitting();
  
  Block *getNewBlock(const QString &blockname="\0", const QString &blocktype="\0");

  void register_block(Block *b) {
    constructor_translator[b->get_blocktype()]=b;
  }
  
public slots:
  void emitWarningMessage(const QString &message);
  void emitStatusMessage(const QString &message);
  void emitCaughtCTKError(CTKError &error, QString extra);
  void setDirty();
  void clearDirty();
  void resizeAllBlockWidgets();
  void setRWLayoutBackgroundColour(QColor col);
  void setBlockWidgetsColour(QColor col);
  void profileModeHasChanged();   // Updates block appearances to match new profile mode
  
  
protected:
  
  void closeEvent (QCloseEvent* ce );
  
private:

  CTKStatus saveAndReload();
  void build_constructor_map();
  void buildBlocktypesList();
  void refreshBlocktypeButton();
  void removeAllLayouts(QTabWidget *tabw);
  bool saveWithFileName(const QString &file_name);

  void setMainBlock(Block *block);
  void runSystemNow(int argc, char **argv);
  
private slots:

  void setBlockType(const QString &block_type);
  void dirtyMessageSlot(bool is_dirty);
  void readOnlyMessageSlot(bool is_dirty);

public slots:
 void changeTab(const QString &name);

signals:
  void warningMessage(const QString &message);
  void statusMessage(const QString &message);
  void caughtCTKError(CTKError &error, QString extra);

  void dirtyMessage(bool is_dirty);
  void readOnlyMessage(bool is_dirty);
  
};

#endif


/* End of ctk_gui_centralw.hh */
