/******************************************************************************/
/*									      */
/*	ctk_gui_grid.cpp	      					      */
/*									      */
/*	Author: Jon Barker, Sheffield University			      */
/*									      */
/*      CTK VERSION 1.3.5  Apr 22, 2007		        	      */
/*									      */
/******************************************************************************/

#include "ctk-config.h"

#include "ctk_gui.hh"
#include "ctk_gui_preferences.hh"

#include "ctk_gui_grid.hh"

#include <qcolor.h>
#include <qpainter.h>

/******************************************************************************/
/*									      */
/*	CLASS NAME: Grid                          	      	      */
/*									      */
/******************************************************************************/

const QColor GRID_COLOR = Qt::black;

//const int GRID_SMALLEST = 10;
//const int GRID_LARGEST = 50;
//const int GRID_STEP = 5;


Grid::Grid():grid_on_(false), snap_on_(false) { }

void Grid::valueChanged(int) {
  if (grid_on_) {
    emit valueChanged();
  }
}

void Grid::toggle() {
  grid_on_=(grid_on_==false);
}

void Grid::toggleSnap() {
  snap_on_=(snap_on_==false);
}

bool Grid::isGridOn() const {
  return grid_on_;
}

bool Grid::isSnapOn() const {
  return snap_on_;
}

QPoint Grid::snapToGrid(const QPoint &a_pos) const {
  if (snap_on_==false) 
    return a_pos;
  int grid_space = CTKMainWindow::preferencesw->getGridSize();
  QPoint pos=a_pos;
  pos.setX(pos.x()-pos.x()%grid_space);
  pos.setY(pos.y()-pos.y()%grid_space);
  return pos;
}

void Grid::drawGrid(QPainter *p, const QRect &rect) const {
  if (grid_on_==false) return;
  
  int grid_space = CTKMainWindow::preferencesw->getGridSize();
  
  QPen pen( GRID_COLOR, 0 );
  p->setPen(pen);
   
  int left=rect.left();
  int right=rect.right();  
  int top=rect.top();
  int bottom=rect.bottom();

  left-= (left%grid_space);
  top-= (top%grid_space);

  // draw verticle lines
  for (int i=left; i<=right; i+=grid_space) {
    p->moveTo(i, top);
    p->lineTo(i, bottom);
  }

  // draw horizontal lines
  for (int i=top; i<=bottom; i+=grid_space) {
    p->moveTo(left, i);
    p->lineTo(right, i);
  }

  
}

#include "moc_ctk_gui_grid.cpp"

/* End of ctk_gui_grid.cpp */
