/******************************************************************************/
/*									      */
/*	ctk_gui_grid.hh	        					      */
/*									      */
/*	Author: Jon Barker, Sheffield University			      */
/*									      */
/*      CTK VERSION 1.3.5  Apr 22, 2007			              */
/*									      */
/******************************************************************************/

#ifndef CTK_GUI_GRID_HH
#define CTK_GUI_GRID_HH

#include <qobject.h>

class QPainter;

class BlockWidget;
class ParameterListWidget;


/******************************************************************************/
/*									      */
/*	CLASS NAME: Grid                          	      	      */
/*									      */
/******************************************************************************/


class Grid  : public QObject {
  Q_OBJECT  

private:
  
  bool grid_on_;
  bool snap_on_;
  
  //
  //
  //
  
public:
  
  Grid();

  void toggle();
  void toggleSnap();

  QPoint snapToGrid(const QPoint &pos) const;

  void drawGrid(QPainter *p, const QRect &rect) const;

  
private:
  
  bool isGridOn() const;
  bool isSnapOn() const;

private slots:
void valueChanged(int value);
  
  signals:
void valueChanged();

};

#endif

/* End of ctk_gui_grid.hh */
