/******************************************************************************/
/*									      */
/*	ctk_gui_param.hh	      					      */
/*									      */
/*	Author: Jon Barker, Sheffield University			      */
/*									      */
/*      CTK VERSION 1.3.5  Apr 22, 2007			              */
/*									      */
/******************************************************************************/

#ifndef CTK_GUI_PARAM_HH
#define CTK_GUI_PARAM_HH

#include <qlineedit.h>
#include <qdialog.h>
#include <qframe.h>
#include <qspinbox.h>

#include <ctk_socket.hh>


class QLineEdit;
class QSpinBox;
class QLabel;
class QHBoxLayout;
class QComboBox;
class QCheckBox;

class BlockWidget;
class ParameterListWidget;
class ScriptParameterWidget;
class Param;
class ParamList;

const int MAX_NUMBER_OF_SOCKETS = 8;
const int MAX_PARAMS_PER_PANEL = 10;



/******************************************************************************/
/*									      */
/*	CLASS NAME: ParameterWidget		      			      */
/*									      */
/******************************************************************************/

class ParameterWidget: public QFrame {
  Q_OBJECT
  
private:

  QHBoxLayout *top_layout_;

  const Param *param_;
  ParameterListWidget *paramlistw_;

  QPushButton *label_;
  QLabel * const_value_;

  ScriptParameterWidget *script_paramw_;

  //
  //
  //
  
public:
  
  ParameterWidget(const Param *a_param, QWidget *parent, ParameterListWidget *param_list_widget);

protected:

  void addToWidget(QWidget *w);
  
  virtual void refreshWithValueFromCTK()=0;
  
  QString getParamString();
  const Param *getParam();
  ParameterListWidget *getParamW(){return paramlistw_;}

private:
  void paintEvent(QPaintEvent *e);

private slots:
  
  void paramButtonPushed(bool state);
  
  
};

/******************************************************************************/
/*									      */
/*	CLASS NAME: GetIntegerModal      		      		      */
/*									      */
/******************************************************************************/

class GetIntegerModal : public QDialog {
  Q_OBJECT
  
private:
  
  QSpinBox *spin_;
  
public:
  
  GetIntegerModal( QWidget *parent, QString name );
  
  int getInt() const;
  
};


/******************************************************************************/
/*									      */
/*	CLASS NAME: ParameterLineEditWidget	              		      */
/*									      */
/******************************************************************************/

class ParameterLineEditWidget: public ParameterWidget {
  Q_OBJECT
  
private:
  QLineEdit *line_edit_;
  
  //
  //
  //
  
public:
  
  ParameterLineEditWidget(const Param *p, QWidget *parent, ParameterListWidget *param_list_widget, bool read_only=false);


protected:
  virtual void refreshWithValueFromCTK();
  
private:

private slots:

void setNewValue();
};

/******************************************************************************/
/*									      */
/*	CLASS NAME: ParameterComboWidget	              		      */
/*									      */
/******************************************************************************/

class ParameterComboWidget: public ParameterWidget {
  Q_OBJECT
  
private:
  QComboBox *combo_box_;
  
  //
  //
  //
  
public:
  
  ParameterComboWidget(const Param *p, QWidget *parent, ParameterListWidget *param_list_widget, bool read_only=false);

protected:
  virtual void refreshWithValueFromCTK();

private:
  QStringList *getValidStrings();
  
private slots:

void setNewValue(const QString &value);
};


/******************************************************************************/
/*									      */
/*	CLASS NAME: ParameterCheckBoxWidget	              		      */
/*									      */
/******************************************************************************/

class ParameterCheckBoxWidget: public ParameterWidget {
  Q_OBJECT
  
private:
  QCheckBox *check_box_;
  
  //
  //
  //
  
public:
  
  ParameterCheckBoxWidget(const Param *p, QWidget *parent, ParameterListWidget *param_list_widget, bool read_only=false);
  
protected:
  virtual void refreshWithValueFromCTK();
  
private slots:

void setNewValue();
};


/******************************************************************************/
/*									      */
/*	CLASS NAME: ParameterListWidget		      			      */
/*									      */
/******************************************************************************/

class ParameterListWidget: public QFrame {
  Q_OBJECT
  
private:
  BlockWidget *blockw_;
  const Block *block_;
  const ParamList *param_list_;
  vector<ParameterWidget *> paramw_list_;
  QSpinBox *input_socketw_;
  QSpinBox *output_socketw_;
  
  // Widget for displaying block's name
  class ParameterEdit *name_edit_;
  
  QLabel *label_;
  bool is_read_only_;
  
public:
  
  ParameterListWidget(BlockWidget *ablock, bool read_only=false);

  BlockWidget *getBlockW() const {return blockw_;}
  
  void refreshParameters();
  void setParameter(QString name, QString value);
  void setParameterArgNumber(QString name, int value);
  void unsetParameter(QString name);
  
  void paintEvent(QPaintEvent *e);

private:
  QWidget *makeSocketController(SocketType socket_type, int nsockets);
  
private slots:

void setNewBlockName();
void setNumInputs(int n);
void setNumOutputs(int n);

};

/******************************************************************************/
/*									      */
/*	CLASS NAME: ParameterEdit		      			      */
/*									      */
/******************************************************************************/

// Same as line edit but with mouse move event overwritten so that the parameter gets
// set as soon as the user tries to move out of focus

class ParameterEdit: public QLineEdit {
  Q_OBJECT
  
public:


  ParameterEdit ( QWidget * parent, const char * name=0 );
  ParameterEdit ( const QString & contents, QWidget * parent, const char * name=0 );

  virtual void focusOutEvent ( QFocusEvent * );

  signals:

  void parameterLostFocus();

};

#endif

/* End of ctk_gui_param.hh */
