/******************************************************************************/
/*									      */
/*	ctk_gui_preferences.hh	      					      */
/*									      */
/*	Author: Jon Barker, Sheffield University			      */
/*							 		      */
/*      CTK VERSION 1.3.5  Apr 22, 2007			                      */
/*							 		      */
/******************************************************************************/

#ifndef CTK_GUI_PREFERENCES_HH
#define CTK_GUI_PREFERENCES_HH

#include <qframe.h>

#include "ctk_local.hh"

class QSlider;
class QWidget;
class QLabel;

class BlockWidget;
class CTKSliderWidget;

/******************************************************************************/
/*									      */
/*	CLASS NAME: PreferencesWidget		      			      */
/*									      */
/******************************************************************************/

enum {PROFILE_DISPLAY_MODE_PERCENTAGE, PROFILE_DISPLAY_MODE_TIME, PROFILE_DISPLAY_MODE_CALLS};

class PreferencesWidget: public QFrame {
  Q_OBJECT
  
private:
  
  CTKSliderWidget *block_width_pref_w_;
  CTKSliderWidget *block_height_pref_w_;
  class QCheckBox *block_icons_mode_pref_w_;
  CTKSliderWidget *grid_size_pref_w_;
  
  class QButtonGroup *profile_mode_pref_w_;
  class QCheckBox *ctkscript_path_pref_w_;
  class QPushButton *background_colour_pref_w_;
  class QPushButton *block_colour_pref_w_;
  
public:  PreferencesWidget();

  QSize getBlockSize() const;
  int getBlockWidth() const;
  int getBlockHeight() const;
  bool getDisplayIcons() const;
  int getGridSize() const;
  int getProfileMode() const;
  int getCTKScriptPath() const;
  QColor getBackgroundColour() const;
  QColor getBlockColour() const;
  
private slots:
  
  void blockWidthChanged(int value);
  void blockHeightChanged(int value);
  void blockIconsModeChanged(bool value);
  void gridSizeChanged(int value);
  void profileModeChanged(int value);
  void pathModeChanged(bool value);
  void backgroundColourChanged(QColor col);
  void blockColourChanged(QColor col);
  
  void setBlockHeight(int value);
  void setBlockWidth(int value);
  void setGridSize(int value);
  void setBlockIconsMode(bool value);
  void setPathMode(bool value);
  void setProfileMode(int value);
  void setBackgroundColour(QColor col);
  void setBlockColour(QColor col);
  
private:
  
  void drawGeneralTab(QWidget *tabw);
  void drawProfileTab(QWidget *tabw);
  void drawSaveTab(QWidget *tabw);
  void drawColourTab(QWidget *tabw);
  
  signals:
  
  void signalBlockSizePreferenceChanged();
  void signalBlockIconsModePreferenceChanged(bool value);
  void signalGridSizePreferenceChanged(int value);
  void signalProfileModePreferenceChanged(int value);
  void signalBackgroundColourChanged(QColor col);
  void signalBlockColourChanged(QColor col);
  
  private slots:
  
  CTKStatus savePreferences() const;
  CTKStatus revertToSaved();
  void revertToDefault();
  void selectBackgroundColour();
  void selectBlockColour();

};


/******************************************************************************/
/*									      */
/*	CLASS NAME: CTKSliderWidget		      			      */
/*									      */
/******************************************************************************/

class CTKSliderWidget: public QFrame {
  Q_OBJECT
  
private:

  QSlider *slider_;
  QLabel *value_text_;
  
  //
  //
  //
  
public:
  
  CTKSliderWidget(int min, int max, int step, int value, const char *label, QWidget *w);

  int value() const;
  
public slots:
  
  void setValue(int value);

protected:
  
  signals:
  
  void valueChanged(int);
  
};

#endif

/* End of ctk_gui_preferences.hh */
