/******************************************************************************/
/*									      */
/*	ctk_gui_profile.cpp	      					      */
/*									      */
/*	Author: Jon Barker, Sheffield University			      */
/*									      */
/*      CTK VERSION 1.3.5  Apr 22, 2007		        	      */
/*									      */
/******************************************************************************/

#include "ctk-config.h"

#include <qlayout.h>
#include <qstring.h>
#include <qlabel.h>

#include "ctk_block.hh"

#include "ctk_gui_blockw.hh"
#include "ctk_gui_profile.hh"


/******************************************************************************/
/*									      */
/*	CLASS NAME: BlockProfileWidget		      			      */
/*									      */
/******************************************************************************/


BlockProfileWidget::BlockProfileWidget(BlockWidget *this_block):QFrame() {

  blockw=this_block;
  const Block *block=blockw->getBlock();
  
  QBoxLayout *top_layout = new QVBoxLayout(this,5);
  
  top_layout->addWidget(new QLabel(QString(tr("Type: "))+block->get_blocktype().c_str(),this));
  top_layout->addWidget(new QLabel(QString(tr("Name: "))+block->getfullname().c_str(),this));
  
  QHBoxLayout *row1 = new QHBoxLayout();
  row1->addWidget(new QLabel("Calls", this));
  row1->addWidget(calls_w_=new QLabel("--", this));
  top_layout->addLayout(row1);

  QHBoxLayout *row2 = new QHBoxLayout();
  row2->addWidget(new QLabel("Total time: ", this));
  row2->addWidget(total_time_w_ = new QLabel("--", this));
  row2->addWidget(new QLabel("sec", this));
  top_layout->addLayout(row2);

  QHBoxLayout *row3 = new QHBoxLayout();
  row3->addWidget(new QLabel("Percentage time: ", this));
  row3->addWidget(percentage_time_w_ = new QLabel("--", this));
  row3->addWidget(new QLabel("%", this));
  top_layout->addLayout(row3);

  refreshProfile();

  QPushButton *close_button;
  top_layout->addWidget(close_button=new QPushButton(tr("Close"), this));
  connect( close_button, SIGNAL(clicked()), this, SLOT(hide()));
 
}



void BlockProfileWidget::refreshProfile() {
  calls_w_->setNum(blockw->getBlock()->get_profile_call_count());
  total_time_w_->setNum(blockw->getBlock()->get_profile_process_time());
  percentage_time_w_->setNum(blockw->getBlock()->get_profile_process_time_percentage());
  
}

#include "moc_ctk_gui_profile.cpp"

/* End of ctk_gui_profile.cpp */
