/******************************************************************************/
/*									      */
/*	ctk_helpwindow.cpp	      		              		      */
/*									      */
/*	Author: Jon Barker, Sheffield University			      */
/*						   			      */
/*      CTK VERSION 1.3.5  Apr 22, 2007	           		      */
/*									      */
/******************************************************************************/


#ifndef CTK_HELPWINDOW_HH
#define CTK_HELPWINDOW_HH

//#include <qtextbrowser.h>
#include <qmainwindow.h>
#include <qstringlist.h>
#include <qmap.h>
#include <qdir.h>

class QTextBrowser;
class QComboBox;
class QPopupMenu;

/******************************************************************************/
/*									      */
/*	CLASS NAME: HelpWindow		        			      */
/*									      */
/******************************************************************************/

class HelpWindow : public QMainWindow {
  Q_OBJECT
public:
  HelpWindow( const QString& home,  const QString& path, QWidget* parent = 0, const char *name=0 );
  ~HelpWindow();
  
private slots:
  void setBackwardAvailable( bool );
  void setForwardAvailable( bool );
  
  void textChanged();
  void about();
  void openFile();
  void newWindow();
  
  void pathSelected( const QString & );
  void histChosen( int );
  void bookmChosen( int );
  void addBookmark();
    
private:
  bool eventFilter( QObject * o, QEvent * e );
  void readHistory();
  void readBookmarks();
  
  QTextBrowser* browser_;
  QComboBox *path_combo_;
  int backward_id_, forward_id_;
  QString selected_URL_;
  QDir path_;
  QStringList file_list_;
  QStringList history_;
  QStringList bookmarks_;
  QMap<int, QString> history_map_;
  QMap<int, QString> bookmark_map_;
  QPopupMenu *hist_menu_;
  QPopupMenu *book_menu_;
    
};





#endif

