/******************************************************************************/
/*									      */
/*	ctk_correlator.hh   			      			      */
/*									      */
/*	Class declarations for ctk_correl.cpp	               	      	      */
/*									      */
/*      Author: Sue Harding, Sheffield University                             */
/*      based on autocorrel by Jon Barker, Sheffield University               */
/*                                                                            */
/*      CTK VERSION 1.3.5  Apr 22, 2007		         	      */
/*									      */
/******************************************************************************/

#ifndef CTK_CORRELATOR_HH
#define CTK_CORRELATOR_HH

#include "ctk_block.hh"


/******************************************************************************/
/*                                                                            */
/*       CLASS NAME: CorrelatorBlock                                              */
/*                                                                            */
/******************************************************************************/

class CorrelatorBlock:public Block {

private:

  static const string type_name;
  static const string help_text;
  static const char *PARAM_VERSIONS[];
  static const char *PARAM_DEFAULT_VERSION;

  class ParamString *AXIS0_param;
  class ParamString *AXIS1_param;
  class ParamBool *NORMALISE_param;
  class ParamEnumerated *WINDOW_param;
  class ParamEnumerated *VERSION_param;

  class ParamInt *WINDOW_SIZE_param;
  class ParamInt *MAX_LAG_param;
  
  string axis_to_use0;
  string axis_to_use1;
  
  // No. of input sockets is 1 or 2
  Integer n_dims[2];   // Number of input dimensions (per socket)
  vector<Integer> dim_sizes[2]; // Size of input dimensions (per socket)
  vector<Integer> strides[2]; // No. of strides (per socket)

  Integer out_storage;  // Storage required for output data

  Boolean normalise;

  int max_lag;
  int window_size;
  
  // Storage for optimized 2-D case precompute
  Integer dims_x[2], dims_y[2], stride_y[2], stride_x[2];	// dimension and stride lengths for the two axes (x, y) for each input
  Integer x_dim[2];	// Index number for the x axis for each input
  Integer min_dims_x;   // Minimum dimension size for the x axis
  Integer min_dims_y;   // Minimum dimension size for the y axis
  
public:

  CorrelatorBlock(string a_name);
  virtual ~CorrelatorBlock(){};

  virtual Block* clone(const string &new_name) const;

  virtual const string &get_helptext() const {return help_text;}

private:
 
  virtual void reset();

  virtual void build_output_data_descriptors();

  virtual void compute();


};


#endif


/* End of ctk_correlator.hh */
