/******************************************************************************/
/*									      */
/*	ctk_filter.hh   			      			      */
/*									      */
/*	Class declarations for ctk_filter.cpp	               	      */
/*									      */
/*	Author: Jon Barker, Sheffield University			      */
/*									      */
/*      CTK VERSION 1.3.5  Apr 22, 2007			      */
/*									      */
/******************************************************************************/

#ifndef CTK_FILTER_HH
#define CTK_FILTER_HH

#include <cstdio>

#include "ctk_block.hh"



/******************************************************************************/
/*                                                                            */
/*       CLASS NAME: FilterBlock                                              */
/*                                                                            */
/******************************************************************************/

class FilterBlock:public Block {

  static const string type_name;
  static const string help_text;

private:
  
  class ParamFloatVector *A_param;
  class ParamFloatVector *B_param;
  class ParamString *FILENAME_param;
  
  vector<Float> a_coeffs;
  vector<Float> b_coeffs;

  vector<vector<Float> > xstorage;
  vector<vector<Float> > ystorage;
  
  Integer nA, nB;
  Integer index_A, index_B;  
  Integer offset_A, offset_B;  

  Integer width;
  
  //
  //
  //
  
public:

  FilterBlock(const string &a_name);
  virtual ~FilterBlock(){};

  virtual Block* clone(const string &new_name) const;

  virtual const string &get_helptext() const {return help_text;}

private:
 
  virtual void reset();
  virtual void compute();
  virtual void close();

  void read_filter_coefficients_from_file(string filename, vector<Float> &A, vector<Float> &B);
  bool read_vector(FILE *fp, vector<Float> &x);
  
};


template <class T>
void resize_static_array(vector<vector<T> > &matrix, int x, int y) {
  matrix.resize(y);
  for (int i=0; i<y; ++i) 
    matrix[i].resize(x);
}

template <class T>
void makeXtoXX (vector<T> &x) {
  int n=x.size();
  x.resize(n*2);
  copy(x.begin(), x.begin()+n, x.begin()+n);
}

#endif


/* End of ctk_filter.hh */
