/******************************************************************************/
/*									      */
/*	ctk_framer.hh   						      */
/*									      */
/*	Class declarations for ctk_framer.cpp		         	      */
/*									      */
/*	Author: Jon Barker, Sheffield University			      */
/*									      */
/*      CTK VERSION 1.3.5  Apr 22, 2007			      */
/*									      */
/******************************************************************************/

#ifndef CTK_FRAMER_HH
#define CTK_FRAMER_HH

#include "ctk_block.hh"

/******************************************************************************/
/*                                                                            */
/*       CLASS NAME: FramerBlock                                              */
/*                                                                            */
/******************************************************************************/

const Integer	PARAM_DEFAULT_FRAME_SHIFT	= 1;
const Integer   PARAM_DEFAULT_FRAME_SIZE        = 1;


class FramerBlock:public Block {

  static const char *PARAM_DEFAULT_WINDOW_SHAPE;
  static const string help_text;
  static const string type_name;

private:

  CTKVector window;

  class ParamInt *SHIFT_param;
  class ParamInt *SIZE_param;
  class ParamEnumerated *SHAPE_param;

  Integer gap;
  Boolean first_call;
  Integer overlap;
  Boolean is_rectangle;  // True if a rectangle framing window is applied
  Float input_sample_rate; // Input sample rate - i.e. SAMPLE_RATE before it is divided
  
  string axis_name;  // The name of the axis to generate  - either TIME or TIME_2

  CTKVector dataS;     // Space into which to read input samples into frame 
  CTKVector junkS;     // Space into which to dump sample data between frames
  CTKVector frame;    // Space for constructing windowed output frame

  vector<CTKVector *> dataF;  // Space for reading input frames into frame
  vector<CTKVector *> junkF;  // Space into which to dump frame data between frames
  //
  //
  //
  
public:

  FramerBlock(const string &a_name);

  virtual ~FramerBlock();

  virtual Block* clone(const string &new_name) const;

  virtual const string &get_helptext() const {return help_text;}

private:

  virtual void reset();

  virtual void build_output_data_descriptors();
  
  virtual void compute();

  void free_storage();
};


#endif

/* End of ctk_framer.hh */
