/******************************************************************************/
/*									      */
/*	ctk_haircell.hh   		      		        	      */
/*									      */
/*	Class declarations for ctk_haircell.cpp	                 	      */
/*									      */
/*	Author: Jon Barker, Sheffield University			      */
/*									      */
/*      CTK VERSION 1.3.5  Apr 22, 2007			      */
/*									      */
/******************************************************************************/

#ifndef CTK_HAIRCELL_HH
#define CTK_HAIRCELL_HH

#include "ctk_block.hh"

/******************************************************************************/
/*                                                                            */
/*       CLASS NAME: HaircellBlock                                            */
/*                                                                            */
/******************************************************************************/

class HaircellBlock:public Block {

public:

  HaircellBlock(const string &a_name, const string &a_block_type);
  virtual ~HaircellBlock(){};

  virtual Block* clone(const string &new_name) const=0;

protected:
  virtual void reset();
  
private:
  void compute()=0;
};



/******************************************************************************/
/*                                                                            */
/*       CLASS NAME: MeddisHaircellBlock                                      */
/*                                                                            */
/******************************************************************************/

/* hair cell constants from Meddis' 1988 paper */

const Float MED_Y=5.05;
const Float MED_G=2000.0;
const Float MED_L=2500.0;
const Float MED_R=6580.0;
const Float MED_X=66.31;
const Float MED_A=3.0;
const Float MED_B=300.0;
const Float MED_H=48000.0;
const Float MED_M=1.0;

class MeddisHaircellBlock:public HaircellBlock {

private:
  static const string type_name;
  static const string help_text;

  Float xdt, ydt, ymdt;
  Float lplusrdt;
  Float rdt, gdt, hdt;
  Float kt;
  Float c;
  Float q, w;
  Float dt;

public:

  MeddisHaircellBlock(const string &a_name);
  virtual ~MeddisHaircellBlock(){};

  virtual Block* clone(const string &new_name) const;

  virtual const string &get_helptext() const {return help_text;}

protected:

  virtual void reset();
  virtual void compute();
  inline Float do_meddis(Float sample);
  
};



#endif

/* End of ctk_haircell.hh */
