/******************************************************************************/
/*									      */
/*	ctk_noise_estimation.hh   		      		     	      */
/*									      */
/*	Class declarations for ctk_noise_estimation.cpp	              	      */
/*									      */
/*	Author: Jon Barker, Sheffield University			      */
/*									      */
/*      CTK VERSION 1.3.5  Apr 22, 2007			      */
/*									      */
/******************************************************************************/

#ifndef CTK_NOISE_ESTIMATION_HH
#define CTK_NOISE_ESTIMATION_HH

#include "ctk_block.hh"

class ParamInt;

/******************************************************************************/
/*                                                                            */
/*       CLASS NAME: NoiseEstimationBlock                                     */
/*                                                                            */
/******************************************************************************/

class NoiseEstimationBlock:public Block {
private:
  ParamInt *NFRAMES_param;
  ParamBool *IGNORE_LARGE_param;

  vector<CTKVector *> frame_buffer;
  Integer frame_count;

  //
  //
  //
  
public:

  NoiseEstimationBlock(const string &a_name, const string &a_block_type);
  virtual ~NoiseEstimationBlock();

  virtual Block* clone(const string &new_name) const=0;

protected:
  virtual void reset();

  Boolean is_initialising();
  void initialise(CTKVector *noise_estimate, CTKVector *noise_estimate_variance);
  
private:
  void compute()=0; 

  void make_initial_estimate(CTKVector *noise_estimate, CTKVector *noise_estimate_variance);
  void output_initial_frames(CTKVector *noise_estimate, CTKVector *noise_estimate_variance);

  CTKStatus calculate_buffer_mean(const vector <CTKVector *> &buffer, CTKVector *mean) const;
  CTKStatus calculate_buffer_mean_of_lowest(const vector <CTKVector *> &buffer, CTKVector *mean) const;

  void free_storage();
};



/******************************************************************************/
/*                                                                            */
/*       CLASS NAME: StationaryNoiseEstimationBlock                           */
/*                                                                            */
/******************************************************************************/

class StationaryNoiseEstimationBlock:public NoiseEstimationBlock {

private:
   
  static const string type_name;
  static const string help_text;

  CTKVector noise_estimate;
  CTKVector noise_estimate_variance;
  
public:

  StationaryNoiseEstimationBlock(const string &a_name);
  virtual ~StationaryNoiseEstimationBlock(){};

  virtual Block* clone(const string &new_name) const;

  virtual const string &get_helptext() const {return help_text;}

protected:
  virtual void reset();

private:
  virtual void compute();  
};

/******************************************************************************/
/*                                                                            */
/*       CLASS NAME: HirschWANoiseEstimationBlock                             */
/*                                                                            */
/******************************************************************************/

const Float	PARAM_DEFAULT_HIRSCH_WA_ALPHA	= 0.98;
const Float	PARAM_DEFAULT_HIRSCH_WA_BETA	= 2.00;

class HirschWANoiseEstimationBlock:public NoiseEstimationBlock {

private:

  static const string type_name;
  static const string help_text;

  ParamFloat *ALPHA_param;
  ParamFloat *BETA_param;
   
  CTKVector noise_estimate;
  CTKVector noise_estimate_variance;

  Float alpha;
  Float beta;
  Float one_minus_alpha;
  
public:

  HirschWANoiseEstimationBlock(const string &a_name);
  virtual ~HirschWANoiseEstimationBlock(){};

  virtual Block* clone(const string &new_name) const;

  virtual const string &get_helptext() const {return help_text;}

protected:
  virtual void reset();

private:
  virtual void compute();
  inline Float new_noise(Float noise, Float observed);
  
};


#endif

/* End of ctk_noise_estimation.hh */
