/******************************************************************************/
/*									      */
/*	ctk_process_groups.hh   			             		      */
/*									      */
/*	Class declarations for ctk_process_groups.cpp	               	      */
/*									      */
/*	Author: Jon Barker, Sheffield University              	      	      */
/*									      */
/*      CTK VERSION 1.3.5  Apr 22, 2007                   		      */
/*									      */
/******************************************************************************/

 
#ifndef CTK_PROCESS_GROUPS_HH
#define CTK_PROCESS_GROUPS_HH

#include <deque>
#include <map>

#include "ctk_block.hh"



/******************************************************************************/
/*									      */
/*	CLASS NAME: MergeGroupsBlock		              	       	      */
/*									      */
/******************************************************************************/

class MergeGroupsBlock:public Block {

  static const string type_name;
  static const string help_text;

private:
  

  ParamEnumerated *MERGE_MODE_param;

  int merge_mode;
  
  map<string, int> label_pair_map;
  int next_group_label;
  
public:

  
  MergeGroupsBlock(const string &a_name);
  virtual ~MergeGroupsBlock();

  virtual Block* clone(const string &new_name) const;
  
  virtual const string &get_helptext() const {return help_text;}

private:

  virtual void reset();

  virtual void compute();

  virtual void close();

  int mergeGroups(int group_label1, int group_label2);
  
};

/******************************************************************************/
/*									      */
/*	CLASS NAME: CutGroupsBlock		              	       	      */
/*									      */
/******************************************************************************/

class CutGroupsBlock:public Block {

  static const string type_name;
  static const string help_text;

private:
  
  map<int, int> group_map;
  int next_group_label;
  int last_x;
  
public:

  
  CutGroupsBlock(const string &a_name);
  virtual ~CutGroupsBlock();

  virtual Block* clone(const string &new_name) const;
  
  virtual const string &get_helptext() const {return help_text;}

private:

  virtual void reset();

  virtual void compute();

  virtual void close();

  int relabelGroups(int x);
  
};

#endif

/* End of ctk_process_groups.hh */
