/******************************************************************************/
/*									      */
/*	Codebook.cpp	                  	      	      	              */
/*									      */
/*	   ?????               */
/*									      */
/*	Author: Shaoxu, ??
/*									      */
/*     	CTK VERSION 1.3.5  Apr 22, 2007		      	      */
/*						 			      */
/******************************************************************************/
 
#include <iostream.h>

#include <fstream>
#include <string>

#include "Codebook.hh"

Codebook::Codebook(const char* filename) {
  /*
  std::ifstream *infile;
  infile=new ifstream(filename);
  
  if (!(*infile)){
    cerr<<"Can not open file!!!" << endl;
    exit(EXIT_FAILURE);
  }
  
  char c;
  string s;
  int i=0;
  int k=0;
  int meancomp=0;
  int meansize=0;
  int varicomp=0;
  int varisize=0;

  while(infile->get(c)){
    if(c!='\n'){
      if(c==',')
	{
	  if (i==0) probj[k++]=atof(s.c_str());
	  else if(i<=SIZE){
	    if (meancomp>=DIM){
	      meancomp=0;
	      meansize++;
	    }
	    meanvec[meansize].push_back(atof(s.c_str()));
	    meancomp++;
	  }else {
	    if(varicomp>=DIM){
	      varicomp=0;
	      varisize++;
	    }	      
	    vari[varisize][varicomp]=atof(s.c_str());
	    varicomp++;
	  }
	  s.erase();	
	}else s+=c;
    }else {
      i++;
    }
  }

  print();
  
  delete infile;

  */
}

Codebook::~Codebook(){}

int Codebook::getcluster(const vector<double> &invec){
    
  vector<double> kst(SIZE);
  vector<double> tempdiff(DIM);
  vector<double> invervari(DIM);

  for(int i=0;i<SIZE;i++){
    
    double cita=1.0;

    for (int m=0;m<DIM;m++){
      cita*=vari[i][m];
      tempdiff[m]=invec[m]-meanvec[i][m];
    }
    
    for(int m=0;m<DIM;m++){
      double tempout=1.0;
      for (int n=0;n<m;n++)
	tempout*=vari[i][n];
      for(int n=m+1;n<DIM;n++)
	tempout*=vari[i][n];	
      invervari[m]=tempout/cita;	
    }
    
    double tempsum=0.0;
    for(int m=0;m<DIM;m++)
      tempsum+= tempdiff[m]* tempdiff[m] * invervari[m];
    
    kst[i]=0.5*tempsum-(double)log(probj[i])+0.5*log(cita);
    
  }
  
  int number=0;
  double minval=kst[0];
  
  for(int m=1;m<SIZE;m++) {
    if (kst[m]<minval) {
      minval=kst[m];number=m;
    }	
  }
  
  cerr<<"\nCLUSTERNUMBER:"<<number;	
  return number;

}

void Codebook::reconstruct (const vector<double>& invec,const vector<double>& lable, vector<double>  &outvec){
  
 sizeT size=DIM;

 if (invec.size()!=size) {
   cerr << "The input vector error"<<invec.size();
   exit(EXIT_FAILURE);
 }
 
 if (lable.size()!=size) {
   cerr << "The lable vector error:"<<lable.size();
   exit(EXIT_FAILURE);
 }
 
 // //get the cluster
 // int clusternumber=getcluster(invec);
 int clusternumber=0;
 cerr << "clusternumber= " << clusternumber << endl;

 
 //check if all zero or one for lable if so return outvec=invec 

 unsigned int nmissing=0;
 unsigned int npresent;
 
 count(lable.begin(), lable.end(), 0.0, nmissing);
 
 if((nmissing==(unsigned int)DIM)||(nmissing==0))  {
   outvec=invec; return;
 }

 npresent=DIM-nmissing;
 
 cerr << "NMissing = " << nmissing << "\n";
 
 //divide the invec into invecm and inveco
 
 
 dense1D<double> invecm(nmissing);
 dense1D<int> invecmnumber(nmissing);

 dense1D<double> invecodiff(npresent);
 dense1D<double> inveco(npresent);
 
 int i=0, j=0, k=0;
 
 for (vector<double>::const_iterator pos0=lable.begin(), pos1=invec.begin();pos0!=lable.end();++pos0, ++pos1, ++i){
   double x=*pos1;
   if (*pos0==0.0) {
     invecm[j]=x;
     invecmnumber[j]=i;
     ++j;
   } else {
     inveco[k]=x;
     cerr << "xx1\n";
     //     invecodiff[k]=x-meanvec[clusternumber][i];
     invecodiff[k]=x;
     cerr << "xx2\n";
     ++k;
   }
 }
 

 Matrix moo(npresent, npresent);
 Matrix invmoo(npresent, npresent);
  
 for(unsigned int i=0;i<npresent;i++) {
   for(unsigned int j=0;j<npresent;j++){
     moo(i,j)=(invecodiff[i]*invecodiff[j]);
   }
 }

 //// get the inverse of moo
 getinversematrix(moo,invmoo);

 //construct two matrix
 Matrix mmo(nmissing,npresent);
 for (unsigned int i=0;i<nmissing;i++)
   for(unsigned int j=0;j<npresent;j++)
     mmo(i,j)=(invecm[i]-meanvec[clusternumber][i])*invecodiff[j];
  
 
 //reconstruct
 Matrix tempproduct1(nmissing, npresent);
 mult(mmo,invmoo,tempproduct1);
 
 Vector tempsmproduct(nmissing);

 // mult(tempproduct1,tempsm,tempsmproduct);
 mult(tempproduct1,invecm,tempsmproduct);

 vector<double> sm;

 vector<int>::iterator pos2=invecmnumber.begin();
 for (unsigned int i=0;i<nmissing;i++){
   sm.push_back(meanvec[clusternumber][(int)*pos2]+tempsmproduct[i]);
   ++pos2;
 }			  
 
 //reconstruct
 bool ismiss;

 outvec.resize(0);

 for(int i=0;i<DIM;i++){
   ismiss=false;
   int m=0;
   
   for(dense1D<int>::iterator pos2=invecmnumber.begin(); pos2!=invecmnumber.end(); ++pos2, ++m){
     if(*pos2==i) {
       outvec.push_back(sm[m]);
       ismiss=true;
       break;
     } 
   }
  
   
   if(!ismiss)
     outvec.push_back(invec[i]);	
 }
 
 cerr<<"OUTVEC:"<<outvec.size()<<endl;	
 for (vector<double>::iterator pos0=outvec.begin();pos0!=outvec.end();++pos0)
   cerr << *pos0<<" ";
 cerr<<endl;	


}


//void Codebook::getinversematrix(const Matrix& inm,Matrix& outm) const {
void Codebook::getinversematrix(const Matrix& inm,Matrix& outm) const {


  unsigned int size=inm.nrows();

  Matrix output(size,size);
  if (inm.nrows()!=inm.ncols()) {
    cerr << "Codebook::getinversematrix:  Can only invert square matrices\n"; exit(-1);
  }

  if (outm.nrows()!=size || outm.ncols()!=size) {
    cerr << "Codebook::getinversematrix: outm size does not match inm size\n"; exit(-1);
  }
  
  Matrix LU(size, size);
  //  copy(inm, LU);
  for (sizeT i=0; i<LU.nrows(); i++) {
    for (sizeT j=0; j<LU.nrows(); j++)
      LU(i,j) = (double)(rand() % 200 - 100) / 50.0;
  }  
  
  dense1D<int> pvector(size, 0);

  cerr << "matrix to invert\n";
  print_all_matrix(LU);
 
  lu_factor(LU,pvector);

  cerr << "LU factorisation\n";
  print_all_matrix(LU);

  cerr << "Pivots:\n";
  print_vector(pvector);

  lu_inverse(LU,pvector,outm);

  cerr<<"=========INVERSE========\n";	
  Matrix temp(size, size);
  mult(outm,inm,temp);
  print_all_matrix(temp);
 
}


void Codebook::print()
{
  cout<<"PROBJ:"<<endl;
  for (int i=0;i<SIZE;i++)
    cout << probj[i]<< " ";
  cout << endl;
  
  cout<< "MEAN VECTOR:"<<endl;		
  vector<double>::iterator pos;
  for (int i=0;i<SIZE;i++){
    for (pos=meanvec[i].begin();pos!=meanvec[i].end();++pos)
      cout << *pos<<" ";
    cout << endl;	
  }	

  cout << "VARIANCE:"<< endl;
  for (int i=0;i<SIZE;i++){
    for (int k=0;k<DIM;k++)
      cout << vari[i][k]<< " ";
    cout << endl;
  }	
  
}
