/******************************************************************************/
/*									      */
/*	Codebook.h	                  	      	      	              */
/*									      */
/*	   ?????               */
/*									      */
/*	Author: Shaoxu, ??
/*									      */
/*     	CTK VERSION 1.3.5  Apr 22, 2007		      	      */
/*						 			      */
/******************************************************************************/

#ifndef Codebook_H
#define Codebook_H

#include <vector>

const int SIZE=8;
const int DIM=32;

#include <mtl/matrix.h>
#include <mtl/mtl.h>
#include <mtl/utils.h>
#include <mtl/lu.h>

using namespace std;
using namespace mtl;

typedef matrix<double,rectangle<>,dense<>,row_major>::type Matrix ; 
typedef dense1D<double> Vector;
typedef Matrix::size_type sizeT;

class Codebook{

private:

  double vari[SIZE][DIM];
  double probj[SIZE];
  vector<double> meanvec[SIZE];

 public:
  
  Codebook(const char*);
  ~Codebook();
  
  int getcluster(const vector<double> &);
  void reconstruct (const vector<double> &invec,const vector<double> &label,vector<double> &outvec);
  void getinversematrix(const Matrix&, Matrix&) const;
  void print();				
  
};
#endif
