/******************************************************************************/
/*									      */
/*	ctk_impute.cpp	                  	      	      	              */
/*									      */
/*	   ?????               */
/*									      */
/*	Author: Shaoxu, ??               */
/*									      */
/*     	CTK VERSION 1.3.5  Apr 22, 2007		      	      */
/*						 			      */
/******************************************************************************/
  
#include "ctk-config.h"

#include <fstream>
#include <string>

#include "ctk_local.hh"

#include "ctk_socket.hh"
#include "ctk_param.hh"

#include "ctk_codebook.hh"
#include "ctk_impute.hh"

/******************************************************************************/
/*                                                                            */
/*       CLASS NAME: CTK_Impute                                             */
/*                                                                            */
/******************************************************************************/

const string CTK_Impute::help_text =
"shaoxu build this. Applies a windowing function to a frame of data.";

CTK_Impute::CTK_Impute(const string  &a_name):CTKObject(a_name),Block(a_name, "CTK_Impute") {

  // Set up FILE_NAME parameter
  filename_param = new ParamString("FILE_NAME");
  filename_param->set_helptext("The path and filename of the file.");
  parameters->register_parameter(filename_param);

  // Set up FILE_PATH parameter
  file_path_param = new ParamString("FILE_PATH");
  file_path_param->set_helptext("An optional path that is prefixed to the filename");
  parameters->register_parameter(file_path_param);
   
  make_input_sockets(2);
  make_output_sockets(1);

}

string CTK_Impute::getfilename() const {
 string name;
 if (file_path_param->get_set_flag()) {
    name=file_path_param->get_value();
    if (name.size()!=0) name+=(string("/"));
 }
 
 if (filename_param->get_set_flag()) {
    name+=filename_param->get_value();
 }
 
  return name;
}

Block* CTK_Impute::clone(const string &n) const{
  Block *ablock = new CTK_Impute(n.empty()?getname():n);
  return copy_this_block_to(ablock);
}

void CTK_Impute::reset(){

  Block::reset();

  CODE_param=new Codebook(getfilename().c_str()); 

}


void CTK_Impute::compute() {

  CTKVector *v0;
  CTKVector *v1;
  CTKVector *output=new CTKVector(0);
  
  (*input_sockets)[0]->get_vector(v0);
  (*input_sockets)[1]->get_vector(v1);
 
  CODE_param->reconstruct(*v0,*v1,*output); 

  (*output_sockets)[0]->put_vector(output);

  delete v0;
  delete v1;

}


void CTK_Impute::close() {
  delete CODE_param;
  Block::close();
}


/* End of ctk_impute.cpp */
