/******************************************************************************/
/*									      */
/*	ctk_tracker.hh   		 		          	      */
/*									      */
/*									      */
/*	Author: Martin Cooke, Sheffield University			      */
/*									      */
/*       CTK VERSION 1.3.5  Apr 22, 2007			              */
/*									      */
/******************************************************************************/

#ifndef CTK_TRACKER_HH
#define CTK_TRACKER_HH

#include "ctk_block.hh"


/******************************************************************************/
/*                                                                            */
/*       CLASS NAME: TrackerBlock                                     */
/*                                                                            */
/******************************************************************************/

// re-uses some code from string alignment scoring in decoder blocks, which in turn
// came from the matlab version, which in turn came from Steve Young's HTK version...

const Float	PARAM_DEFAULT_CONT	= 7;

struct Trackmap {
  int index;
  float sum;
  int count;
};

typedef map<int,Trackmap> Tmap;
typedef Tmap::iterator Titerator;

class TrackerBlock:public Block {

private:

  static const string type_name;
  static const string help_text;

  class ParamFloat *CONT_param;

  int vector_size;
  int numtracks_last;  // as of last frame, like ref_size
  CTKVector mean_last;    // index to mean of param for last frame
  CTKVector weight_last;
  vector<int> i2c_last;   // index to colour for last frame
  bool first_frame;
  int nextcolour;         // generates unused colours
  Float cont;


public:

  TrackerBlock(const string &a_name);
  virtual ~TrackerBlock(){};

  virtual Block* clone(const string &new_name) const;

  virtual const string &get_helptext() const {return help_text;}

private:
  
  virtual void reset();
  virtual void compute();


};


#endif

/* End of ctk_tracker.hh */
