/******************************************************************************/
/*									      */
/*	ctk_CTK_writer.hh	      					      */
/*									      */
/*	Class declarations for ctk_CTK_writer.cpp			      */
/*									      */
/*	Author: Jon Barker, Sheffield University			      */
/*									      */
/*      CTK VERSION 1.3.5  Apr 22, 2007			      */
/*									      */
/******************************************************************************/

#ifndef CTK_CTK_WRITER_HH
#define CTK_CTK_WRITER_HH

#include <map>
#include <string>
#include <vector>

#include<iosfwd>

class Block;

/******************************************************************************/
/*									      */
/*	CLASS NAME: CTKWriter	         				      */
/*									      */
/******************************************************************************/
typedef enum {INCLUDE_WRITING_MODE, BLOCK_WRITING_MODE} WritingModeType;
enum {CTKSCRIPT_PATH_CAN_BE_CTKROOT=0, CTKSCRIPT_PATH_ALWAYS_CTKLOCAL=1};

class CTKWriter {
private:

  vector<string> written_list;
  string save_file;
  Block *top_block;
  int ctkscript_path;
  //
  //
  //

public:
  CTKWriter();

  
  void save(Block *a_block, string save_file="\0");
  void set_CTKScript_path(int a_ctkscript_path);

private:

  Boolean check_if_system_uses_user_blocks();
  void _recurse_check_if_system_uses_user_blocks (Block *block, Boolean &uses_user_blocks, map<string, Block*> &local_constructor_translator);
 
  void write_header(std::ofstream &ofstr, Boolean use_ctklocal);

  void write_subblocks(std::ofstream &ofstr, Block *block, WritingModeType mode);

  void write_INCLUDE_statements(std::ofstream &ofstr, Block *ablock);
  void write_BLOCK(std::ofstream &ofstr, Block *block);
  void write_helptext(std::ofstream &ofstr, Block *block);
  void write_ADD_statement(std::ofstream &ofstr, Block *ablock);
  void write_parameter_assignments(std::ofstream &ofstr, Block *ablock);
  Integer write_CONNECT_statements(std::ofstream &ofstr, Block *ablock);
  void write_NINPUTS_NOUTPUTS(std::ofstream &ofstr, const class SocketList *sockets, Boolean &first);
  Integer number_of_params_to_write(const class ParamList *param_list);

  Integer write_PARAMETER_statements(std::ofstream &ofstr, Block *ablock);
  Integer write_INPUT_OUTPUT_statements(std::ofstream &ofstr, const class SocketList *sockets);
 

  Boolean has_been_written(string type) const ;
    
  inline Boolean should_output_param(const class Param *param);
  
};


#endif


/* End of ctk_CTK_writer.hh */
