/******************************************************************************/
/*									      */
/*	ctk_array_iterator.hh	    					      */
/*									      */
/*	Iterator for multidimensional arrays			      */
/*									      */
/*	Author: Jon Barker, Sheffield University			      */
/*									      */
/*      CTK VERSION 1.3.5  Apr 22, 2007			      */
/*									      */
/******************************************************************************/

#ifndef CTK_ARRAY_ITERATOR_HH
#define CTK_ARRAY_ITERATOR_HH

/******************************************************************************/
/*									      */
/*	CLASS NAME: array_iterator		      			      */
/*									      */
/******************************************************************************/

template <class T> 
#if defined _KCC
class array_iterator : public iterator<std::bidirectional_iterator_tag, T>
#elif defined _CC
class array_iterator : public iterator<std::bidirectional_iterator_tag, T>
#elif defined _GCC3
class array_iterator : public iterator<std::bidirectional_iterator_tag, T>
#elif defined _GCC
class array_iterator : public input_iterator<T, ptrdiff_t> 
#else
ERROR unknown compiler
#endif
{

 private:
  int stride;
  T *p;
 public:
  array_iterator() {p=NULL;}
  array_iterator(T *ap, int n){p=ap; stride=n;}
  array_iterator &operator=(array_iterator &x){p=x.p; stride=x.stride; return *this;}
  array_iterator &operator++(){p+=stride; return *this;}
  array_iterator &operator+=(int n){p+=(n*stride); return *this;}
  array_iterator &operator-=(int n){p-=(n*stride); return *this;}
  array_iterator operator+(int n){
    array_iterator newit(*this);
    newit.p+=(n*stride);
    return newit;
  }
  array_iterator operator-(int n){
    array_iterator newit(*this);
    newit.p-=(n*stride);
    return newit;
  }
  T operator*(){return *p;}

  int operator-(array_iterator y) {
    if (y.stride!=stride) {
      cerr << "Internal Error: Attempting pointer arithmatic on incompatible array pointers.\n\r";
      exit(-1);
    }
    return ((p-y.p)/stride);
  }
  
  bool operator!=(array_iterator x){return p!=x.p;}
  bool operator==(array_iterator x){return p==x.p;}
};

#endif
/* End of ctk_array_iterator.hh */
