/******************************************************************************/
/*									      */
/*	ctk_dsp.hh   				        		      */
/*									      */
/*	Class declarations for ctk_dsp.cpp      			      */
/*									      */
/*	Author: Jon Barker, Sheffield University			      */
/*									      */
/*      CTK VERSION 1.3.5  Apr 22, 2007			      */
/*									      */
/******************************************************************************/

#ifndef CTK_DSP_HH
#define CTK_DSP_HH

#include <string>

#include "ctk_types.hh"   // For CTKVector

//static const char * VALID_WINDOW_SHAPES[] = {"RECTANGLE","HAMMING","HANNING","TRIANGLE","\0"};

//static const char *VALID_SCALES[] = {"ERB","MEL","LINEAR","\0"};

class StringArrays {
public:
  static const char * VALID_WINDOW_SHAPES[];
  static const char *VALID_SCALES[];
};

inline void SWAP(Float &a, Float &b) {Float tempr=a;a=b;b=tempr;};

void make_window(string shape, CTKVector &window, Integer win_size);

void make_rectangle_window(CTKVector &window, Integer win_size);
void make_hanning_window(CTKVector &window, Integer win_size);
void make_hamming_window(CTKVector &window, Integer win_size);
void make_triangle_window(CTKVector &window, Integer win_size);

void realft(CTKVector &data, Integer isign=1);
void four1(CTKVector &data, Integer nn, Integer isign=1);

void realft(CTKVector data, CTKVector &real, CTKVector &imag);


double random_gaussian(double mean,double stddev);


#endif

/* End of ctk_dsp.hh */
