/******************************************************************************/
/*									      */
/*	ctk_error.cpp	    						      */
/*									      */
/*	Declarations and definitions of CTK exception classes.		      */
/*									      */
/*	Author: Jon Barker, Sheffield University			      */
/*									      */
/*      CTK VERSION 1.3.5  Apr 22, 2007	         		      */
/*									      */
/******************************************************************************/

#include <cstdio>
#include <string>

#include "ctk_local.hh"
#include "ctk_error.hh"

/******************************************************************************/
/*									      */
/*	CLASS NAME: ErrorMessage				      */
/*									      */
/******************************************************************************/

ErrorMessage::ErrorMessage(ErrorCode n, const char *s):code(n), text(s){};
ErrorMessage::ErrorMessage(const ErrorMessage &x):code(x.code), text(x.text) {};

ErrorMessage::~ErrorMessage() {
}

const char *ErrorMessage::get_text() const {
  return text;
}



///////////////////////////////////////////////////////////////////////////////////////////////////
//
//                 EXCEPTION CLASS HIERARCHY
//
//////////////////////////////////////////////////////////////////////////////////////////////////


/******************************************************************************/
/*									      */
/*	CLASS NAME: CTKError - CTK Exception				      */
/*									      */
/******************************************************************************/

CTKError::CTKError(const char *fn, Integer line, ErrorMessage msg, const char *p1, const char *p2, const char *p3):message(msg), lineno(line), filenm(fn), param1(p1), param2(p2), param3(p3) { }
  

CTKError::CTKError(const CTKError &an_error):message(an_error.message),lineno(an_error.lineno), filenm(an_error.filenm), param1(an_error.param1), param2(an_error.param2), param3(an_error.param3) {}
  
CTKError::~CTKError(){}
  
void CTKError::debug_print(const char *caught_at_filenm, const Integer caught_at_lineno) const {
  fprintf(stderr,"%s (%d): ",filenm, lineno);
  fprintf(stderr,message.get_text(),param1,param2,param3);
  caught_print(caught_at_filenm, caught_at_lineno);
}

void CTKError::print(const char *caught_at_filenm, const Integer caught_at_lineno) const {
  fprintf(stderr,message.get_text(),param1,param2,param3);
  caught_print(caught_at_filenm, caught_at_lineno);
}

void CTKError::get_message(char *message_buffer) const {
  sprintf(message_buffer, message.get_text(), param1, param2, param3);
}

void CTKError::caught_print(const char *caught_filenm, const Integer caught_lineno) const {
  if (caught_filenm!=NULL)
    fprintf(stderr,"Exception caught at: %s (%d)\n\r",caught_filenm, caught_lineno);
}
  

ArrayErrorIRE::ArrayErrorIRE(const char *fn, const Integer line, Integer max, Integer x):ArrayError(fn,line,ARRAY_IRE_MESSAGE){
  sprintf(buffer_, "%d",x); param1=strdup(buffer_);
  sprintf(buffer_, "%d",max); param2=strdup(buffer_);
}

ArrayErrorADE::ArrayErrorADE(const char *fn, const Integer line, Integer rank, Integer x):ArrayError(fn,line,ARRAY_ADE_MESSAGE){
 sprintf(buffer_, "%d",x); param1=strdup(buffer_);
 sprintf(buffer_, "%d",rank); param2=strdup(buffer_);
}

/* End of ctk_error.cpp */
