/******************************************************************************/
/*                                                                            */
/*      ctk_file_desc.cpp                                                     */
/*                                                                            */
/*      Implementation of the read once file                                  */
/*                                                                            */
/*      Author: Jon Barker, Sheffield University                              */
/*                                                                            */
/*      CTK VERSION 1.3.5  Apr 22, 2007                              */
/*                                                                            */
/******************************************************************************/

#include "ctk-config.h"

#include "ctk_local.hh"
#include "ctk_error.hh"

#include "ctk_file_desc.hh"
#include "ctk_HMM.hh"

/******************************************************************************/
/*									      */
/*	CLASS NAME: FileDescriptor	                 	       	      */
/*									      */
/******************************************************************************/


FileDescriptor::FileDescriptor(const string &filename, class SetOfHMMs *data):filename_(filename), hmms_data(data),hmm_data(NULL){
  set_mod_time();
}

FileDescriptor::FileDescriptor(const string &filename, class HMM *data):filename_(filename),hmms_data(NULL),hmm_data(data){
  set_mod_time();
}

void FileDescriptor::set_mod_time() {
  struct stat filestat;
  if (stat(filename_.c_str(), &filestat)!=0) {
    perror("FileDescriptor::FileDescriptor");
    throw(CTKError(__FILE__, __LINE__));
  }
  mod_time_=filestat.st_mtime;
};

ReadOnceFile *FileDescriptor::get_data(){
  if (hmms_data!=NULL) {
    return hmms_data;
  } else if (hmm_data!=NULL) {
    return hmm_data;
  } else {
    cerr << "Internal Error: FileDescriptor has NULL data pointer" << endl;
    exit(-1);
  }
  return NULL;
}

bool FileDescriptor::is_upto_date() {
  struct stat filestat;

  //  cerr << "checking file mod time" << endl;
  if (stat(filename_.c_str(), &filestat)!=0) {
    perror("Internal Error");
    exit(-1);
  }
  
  return (mod_time_==filestat.st_mtime);

}

/* End of ctk_file_desc.cpp */

